/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.rewrite.BaseRewriterTestCase;
import org.apache.shindig.gadgets.rewrite.CSSContentRewriter;
import org.apache.shindig.gadgets.rewrite.CaptureRewriter;
import org.apache.shindig.gadgets.rewrite.ContentRewriter;
import org.apache.shindig.gadgets.rewrite.ContentRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.DefaultContentRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.HTMLContentRewriter;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.easymock.classextension.EasyMock;

public class DefaultContentRewriterRegistryTest
extends BaseRewriterTestCase {
    private static final Uri SPEC_URL = Uri.parse((String)"http://example.org/gadget.xml");
    private List<CaptureRewriter> rewriters;
    private List<ContentRewriter> contentRewriters;
    private ContentRewriterRegistry registry;

    protected void setUp() throws Exception {
        super.setUp();
        this.rewriters = Arrays.asList(new CaptureRewriter(), new CaptureRewriter());
        this.contentRewriters = Lists.newArrayList(this.rewriters);
        this.registry = new DefaultContentRewriterRegistry(this.contentRewriters, this.parser);
    }

    public void testRewriteGadget() throws Exception {
        String body = "Hello, world";
        String xml = "<Module><ModulePrefs title=''/><Content>" + body + "</Content></Module>";
        GadgetSpec spec = new GadgetSpec(SPEC_URL, xml);
        GadgetContext context = new GadgetContext();
        Gadget gadget = new Gadget().setContext(context).setSpec(spec);
        String rewritten = this.registry.rewriteGadget(gadget, body);
        DefaultContentRewriterRegistryTest.assertTrue((String)"First rewriter not invoked.", (boolean)this.rewriters.get(0).viewWasRewritten());
        DefaultContentRewriterRegistryTest.assertTrue((String)"Second rewriter not invoked.", (boolean)this.rewriters.get(1).viewWasRewritten());
        DefaultContentRewriterRegistryTest.assertEquals((String)body, (String)rewritten);
    }

    public void testRewriteHttpResponse() throws Exception {
        String body = "Hello, world";
        HttpRequest request = new HttpRequest(SPEC_URL);
        HttpResponse response = new HttpResponse(body);
        HttpResponse rewritten = this.registry.rewriteHttpResponse(request, response);
        DefaultContentRewriterRegistryTest.assertTrue((String)"First rewriter not invoked.", (boolean)this.rewriters.get(0).responseWasRewritten());
        DefaultContentRewriterRegistryTest.assertTrue((String)"Second rewriter not invoked.", (boolean)this.rewriters.get(1).responseWasRewritten());
        DefaultContentRewriterRegistryTest.assertEquals((Object)response, (Object)rewritten);
    }

    public void testRewriteView() throws Exception {
        String body = "Hello, world";
        String xml = "<Module><ModulePrefs title=''/><Content>" + body + "</Content></Module>";
        GadgetSpec spec = new GadgetSpec(SPEC_URL, xml);
        GadgetContext context = new GadgetContext();
        Gadget gadget = new Gadget().setContext(context).setSpec(spec);
        String rewritten = this.registry.rewriteGadget(gadget, spec.getView("default"));
        DefaultContentRewriterRegistryTest.assertTrue((String)"First rewriter invoked.", (boolean)this.rewriters.get(0).viewWasRewritten());
        DefaultContentRewriterRegistryTest.assertTrue((String)"Second rewriter invoked.", (boolean)this.rewriters.get(1).viewWasRewritten());
        DefaultContentRewriterRegistryTest.assertEquals((String)body, (String)rewritten);
    }

    public void testNoDecodeHttpResponseForUnRewriteableMimeTypes() {
        ArrayList rewriters = Lists.newArrayList();
        rewriters.add(this.injector.getInstance(HTMLContentRewriter.class));
        rewriters.add(this.injector.getInstance(CSSContentRewriter.class));
        this.registry = new DefaultContentRewriterRegistry((List)rewriters, this.parser);
        HttpRequest req = this.mock(HttpRequest.class);
        EasyMock.expect((Object)req.getRewriteMimeType()).andReturn((Object)"unknown");
        this.replay();
        HttpResponse rewritten = this.registry.rewriteHttpResponse(req, this.fakeResponse);
        DefaultContentRewriterRegistryTest.assertTrue((rewritten == this.fakeResponse ? 1 : 0) != 0);
        this.verify();
    }
}

