/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.ContainerConfig;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.rewrite.BaseRewriterTestCase;
import org.apache.shindig.gadgets.rewrite.ContentRewriter;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeatureFactory;
import org.apache.shindig.gadgets.rewrite.HTMLContentRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.XPathWrapper;
import org.easymock.classextension.EasyMock;
import org.w3c.dom.Document;

public class HTMLContentRewriterTest
extends BaseRewriterTestCase {
    private HTMLContentRewriter rewriter;

    protected void setUp() throws Exception {
        super.setUp();
        ContentRewriterFeature overrideFeature = this.rewriterFeatureFactory.get(HTMLContentRewriterTest.createSpecWithRewrite(".*", ".*exclude.*", "HTTP", HTMLContentRewriter.TAGS), "shindig");
        ContentRewriterFeatureFactory factory = this.mockContentRewriterFeatureFactory(overrideFeature);
        this.rewriter = new HTMLContentRewriter(factory, (ContainerConfig)new BaseRewriterTestCase.FakeContainerConfig());
    }

    public void testScriptsBasic() throws Exception {
        String content = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/rewritescriptbasic.html"));
        Document doc = this.rewriteContent((ContentRewriter)this.rewriter, content).getDocument();
        XPathWrapper wrapper = new XPathWrapper(doc);
        HTMLContentRewriterTest.assertEquals((String)wrapper.getValue("/html/head/script"), (String)"headScript1");
        HTMLContentRewriterTest.assertEquals((int)wrapper.getNodeList("/html/head/script").getLength(), (int)1);
        HTMLContentRewriterTest.assertEquals((int)wrapper.getNodeList("/html/body/script").getLength(), (int)8);
        HTMLContentRewriterTest.assertEquals((String)wrapper.getValue("/html/body/script[1]"), (String)"bodyScript1");
        HTMLContentRewriterTest.assertEquals((String)wrapper.getValue("/html/body/script[2]/@src"), (String)"http://www.test.com/dir/concat?rewriteMime=text/javascript&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=1150739864&1=http%3A%2F%2Fwww.example.org%2F1.js&2=http%3A%2F%2Fwww.example.org%2F2.js");
        HTMLContentRewriterTest.assertEquals((String)wrapper.getValue("/html/body/script[3]"), (String)"bodyScript2");
        HTMLContentRewriterTest.assertEquals((String)wrapper.getValue("/html/body/script[4]/@src"), (String)"http://www.test.com/dir/concat?rewriteMime=text/javascript&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=1150739864&1=http%3A%2F%2Fwww.example.org%2F3.js");
        HTMLContentRewriterTest.assertEquals((String)wrapper.getValue("/html/body/script[5]"), (String)"<!-- retain-comment -->");
        HTMLContentRewriterTest.assertEquals((String)wrapper.getValue("/html/body/script[6]/@src"), (String)"http://www.test.com/dir/concat?rewriteMime=text/javascript&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=1150739864&1=http%3A%2F%2Fwww.example.org%2F4.js");
        HTMLContentRewriterTest.assertEquals((String)wrapper.getValue("/html/body/script[7]/@src"), (String)"http://www.example.org/excluded/5.js");
        HTMLContentRewriterTest.assertEquals((String)wrapper.getValue("/html/body/script[8]/@src"), (String)"http://www.test.com/dir/concat?rewriteMime=text/javascript&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=1150739864&1=http%3A%2F%2Fwww.example.org%2F6.js");
    }

    public void testLinksBasic() throws Exception {
        String content = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/rewritelinksbasic.html"));
        Document doc = this.rewriteContent((ContentRewriter)this.rewriter, content).getDocument();
        XPathWrapper wrapper = new XPathWrapper(doc);
        HTMLContentRewriterTest.assertEquals((String)wrapper.getValue("//img[1]/@src"), (String)"http://www.test.com/dir/proxy?url=http%3A%2F%2Fwww.example.org%2Fimg.gif&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=1150739864");
        HTMLContentRewriterTest.assertEquals((String)wrapper.getValue("//img[2]/@src"), (String)"http://www.example.org/excluded/img.gif");
        HTMLContentRewriterTest.assertEquals((String)wrapper.getValue("//embed[1]/@src"), (String)"http://www.test.com/dir/proxy?url=http%3A%2F%2Fwww.example.org%2Fsome.swf&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=1150739864");
        HTMLContentRewriterTest.assertEquals((String)wrapper.getValue("//embed[2]/@src"), (String)"http://www.example.org/excluded/some.swf");
    }

    public void testStyleBasic() throws Exception {
        String content = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/rewritestylebasic.html"));
        Document doc = this.rewriteContent((ContentRewriter)this.rewriter, content).getDocument();
        XPathWrapper wrapper = new XPathWrapper(doc);
        HTMLContentRewriterTest.assertEquals((String)wrapper.getValue("//link[1]/@href"), (String)"http://www.test.com/dir/concat?rewriteMime=text/css&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=1150739864&1=http%3A%2F%2Fwww.example.org%2Flinkedstyle1.css&2=http%3A%2F%2Fwww.example.org%2Flinkedstyle3.css&3=http%3A%2F%2Fwww.example.org%2Fimportedstyle1.css&4=http%3A%2F%2Fwww.example.org%2Fimportedstyle3.css&5=http%3A%2F%2Fwww.example.org%2Fimportedstyle4.css");
        HTMLContentRewriterTest.assertEquals((String)wrapper.getValue("//link[2]/@href"), (String)"http://www.example.org/excluded/linkedstyle2.css");
        HTMLContentRewriterTest.assertEquals((String)wrapper.getValue("//link[3]/@href"), (String)"/excluded/importedstyle2.css");
        HTMLContentRewriterTest.assertEquals((int)wrapper.getNodeList("//style").getLength(), (int)1);
        HTMLContentRewriterTest.assertEquals((String)wrapper.getValue("//style[1]"), (String)"div { color : black; }");
    }

    public void testNoRewriteUnknownMimeType() {
        MutableContent mc = this.mock(MutableContent.class, true);
        HttpRequest req = this.mock(HttpRequest.class);
        EasyMock.expect((Object)req.getRewriteMimeType()).andReturn((Object)"unknown");
        this.replay();
        HTMLContentRewriterTest.assertNull((Object)this.rewriter.rewrite(req, this.fakeResponse, mc));
        this.verify();
    }
}

