/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.PropertiesModule;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.DefaultGuiceModule;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.oauth.OAuthModule;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.parse.caja.CajaHtmlParser;
import org.apache.shindig.gadgets.parse.nekohtml.NekoHtmlParser;
import org.apache.shindig.gadgets.parse.nekohtml.NekoSimplifiedHtmlParser;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeatureFactory;
import org.apache.shindig.gadgets.rewrite.HTMLContentRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.lexer.DefaultContentRewriter;
import org.apache.shindig.gadgets.rewrite.lexer.HtmlTagTransformer;
import org.apache.shindig.gadgets.spec.GadgetSpec;

public class LexerVsDomRewriteBenchmark {
    private int numRuns;
    private String content;
    private GadgetHtmlParser cajaParser = new CajaHtmlParser(new ParseModule.DOMImplementationProvider().get());
    private GadgetHtmlParser nekoParser = new NekoHtmlParser(new ParseModule.DOMImplementationProvider().get());
    private GadgetHtmlParser nekoSimpleParser = new NekoSimplifiedHtmlParser(new ParseModule.DOMImplementationProvider().get());
    private Map<String, HtmlTagTransformer> defaultTransformerMap;
    private HTMLContentRewriter htmlRewriter;
    private boolean warmup;
    private ContentRewriterFeatureFactory factory;
    private DefaultContentRewriter lexerRewriter;
    private Gadget gadget;

    private LexerVsDomRewriteBenchmark(String file, int numRuns) throws Exception {
        File inputFile = new File(file);
        if (!inputFile.exists() || !inputFile.canRead()) {
            System.err.println("Input file: " + file + " not found or can't be read.");
            System.exit(1);
        }
        Injector injector = Guice.createInjector((Module[])new Module[]{new PropertiesModule(), new OAuthModule(), new DefaultGuiceModule()});
        this.lexerRewriter = (DefaultContentRewriter)injector.getInstance(DefaultContentRewriter.class);
        this.htmlRewriter = (HTMLContentRewriter)injector.getInstance(HTMLContentRewriter.class);
        this.factory = (ContentRewriterFeatureFactory)injector.getInstance(ContentRewriterFeatureFactory.class);
        final Uri url = Uri.parse((String)"http://www.example.org/dummy.xml");
        GadgetSpec spec = new GadgetSpec(url, "<Module><ModulePrefs title=''/><Content><![CDATA[]]></Content></Module>");
        GadgetContext context = new GadgetContext(){

            public URI getUrl() {
                return url.toJavaUri();
            }
        };
        this.gadget = new Gadget().setContext(context).setSpec(spec);
        this.content = new String(IOUtils.toByteArray((InputStream)new FileInputStream(file)));
        this.numRuns = numRuns;
        this.warmup = true;
        this.runLexer();
        this.run(this.nekoParser);
        this.run(this.nekoSimpleParser);
        Thread.sleep(5000L);
        this.warmup = false;
        System.out.println("Lexer------");
        this.runLexer();
        System.out.println("Neko-------");
        this.run(this.nekoParser);
        System.out.println("NekoSimple-------");
        this.run(this.nekoSimpleParser);
    }

    private void output(String content) {
        if (!this.warmup) {
            System.out.println(content);
        }
    }

    private void runLexer() throws Exception {
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < this.numRuns; ++i) {
            MutableContent mc = new MutableContent(null, this.content);
            this.lexerRewriter.rewrite(this.gadget, mc);
            mc.getContent();
        }
        long time = System.currentTimeMillis() - startTime;
        this.output("Lexer Rewrite [" + time + " ms total: " + (double)time / (double)this.numRuns + "ms/run]");
    }

    private void run(GadgetHtmlParser parser) throws Exception {
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < this.numRuns; ++i) {
            MutableContent mc = new MutableContent(parser, this.content);
            this.htmlRewriter.rewrite(this.gadget, mc);
            mc.getContent();
        }
        long time = System.currentTimeMillis() - startTime;
        this.output("DOM Rewrite [" + time + " ms total: " + (double)time / (double)this.numRuns + "ms/run]");
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Args: <input-file> <num-runs>");
            System.exit(1);
        }
        String fileArg = args[0];
        String runsArg = args[1];
        int numRuns = -1;
        try {
            numRuns = Integer.parseInt(runsArg);
        }
        catch (Exception e) {
            System.err.println("Invalid num-runs argument: " + runsArg + ", reason: " + e);
        }
        try {
            new LexerVsDomRewriteBenchmark(fileArg, numRuns);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

