/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.common.ContainerConfig;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.servlet.HttpUtil;
import org.apache.shindig.gadgets.servlet.ServletTestFixture;
import org.easymock.EasyMock;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpUtilTest
extends ServletTestFixture {
    private static final String CONTAINER = "container";
    private static final String FEATURE_0 = "featureZero";
    private static final String FEATURE_1 = "feature-One";
    private final GadgetContext context = this.mock(GadgetContext.class);

    public void testSetCachingHeaders() {
        HttpUtil.setCachingHeaders((HttpServletResponse)this.recorder);
        this.replay();
        this.checkCacheControlHeaders(31536000, false);
    }

    public void testSetCachingHeadersNoProxy() {
        HttpUtil.setCachingHeaders((HttpServletResponse)this.recorder, (boolean)true);
        this.replay();
        this.checkCacheControlHeaders(31536000, true);
    }

    public void testSetCachingHeadersAllowProxy() {
        HttpUtil.setCachingHeaders((HttpServletResponse)this.recorder, (boolean)false);
        this.replay();
        this.checkCacheControlHeaders(31536000, false);
    }

    public void testSetCachingHeadersFixedTtl() {
        int ttl = 10;
        HttpUtil.setCachingHeaders((HttpServletResponse)this.recorder, (int)ttl);
        this.replay();
        this.checkCacheControlHeaders(ttl, false);
    }

    public void testSetCachingHeadersWithTtlAndNoProxy() {
        int ttl = 20;
        HttpUtil.setCachingHeaders((HttpServletResponse)this.recorder, (int)ttl, (boolean)true);
        this.replay();
        this.checkCacheControlHeaders(ttl, true);
    }

    public void testSetCachingHeadersNoCache() {
        HttpUtil.setCachingHeaders((HttpServletResponse)this.recorder, (int)0);
        this.replay();
        this.checkCacheControlHeaders(0, true);
    }

    private void assertJsonEquals(JSONObject lhs, JSONObject rhs) throws JSONException {
        for (String key : JSONObject.getNames((JSONObject)lhs)) {
            Object obj = lhs.get(key);
            if (obj instanceof String) {
                HttpUtilTest.assertEquals((Object)obj, (Object)rhs.get(key));
                continue;
            }
            if (obj instanceof JSONObject) {
                this.assertJsonEquals((JSONObject)obj, rhs.getJSONObject(key));
                continue;
            }
            HttpUtilTest.fail((String)("Unsupported type: " + obj.getClass()));
        }
    }

    public void testGetJsConfig() throws JSONException {
        JSONObject features = new JSONObject().put(FEATURE_0, (Object)"config").put(FEATURE_1, (Object)"other config");
        ImmutableSet needed = ImmutableSet.of((Object[])new String[]{FEATURE_0, FEATURE_1});
        EasyMock.expect((Object)this.context.getContainer()).andReturn((Object)CONTAINER);
        EasyMock.expect((Object)this.containerConfig.getJsonObject(CONTAINER, "gadgets.features")).andReturn((Object)features);
        this.replay();
        this.assertJsonEquals(features, HttpUtil.getJsConfig((ContainerConfig)this.containerConfig, (GadgetContext)this.context, (Collection)needed));
    }

    public void testGetJsConfigNoFeatures() {
        EasyMock.expect((Object)this.context.getContainer()).andReturn((Object)CONTAINER);
        EasyMock.expect((Object)this.containerConfig.getJsonObject(CONTAINER, "gadgets.features")).andReturn(null);
        this.replay();
        JSONObject results = HttpUtil.getJsConfig((ContainerConfig)this.containerConfig, (GadgetContext)this.context, Collections.emptySet());
        HttpUtilTest.assertEquals((String)"Results should be empty when there are no features", (int)0, (int)results.length());
    }
}

