/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import org.apache.shindig.gadgets.servlet.JsonRpcHandler;
import org.apache.shindig.gadgets.servlet.RpcException;
import org.apache.shindig.gadgets.servlet.RpcServlet;
import org.easymock.classextension.EasyMock;
import org.json.JSONException;
import org.json.JSONObject;

public class RpcServletTest
extends TestCase {
    private RpcServlet servlet;
    private JsonRpcHandler handler;

    public void setUp() throws Exception {
        super.setUp();
        this.servlet = new RpcServlet();
        this.handler = (JsonRpcHandler)EasyMock.createMock(JsonRpcHandler.class);
        this.servlet.setJsonRpcHandler(this.handler);
    }

    public void testDoGetNormal() throws Exception {
        HttpServletRequest request = this.createGetRequest("{\"gadgets\":[]}", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz._");
        HttpServletResponse response = this.createHttpResponse("Content-Disposition", "attachment;filename=rpc.txt", "application/json; charset=utf-8", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz._({\"GADGETS\":[]})", 200);
        JSONObject handlerResponse = new JSONObject("{\"GADGETS\":[]}");
        org.easymock.EasyMock.expect((Object)this.handler.process((JSONObject)org.easymock.EasyMock.isA(JSONObject.class))).andReturn((Object)handlerResponse);
        EasyMock.replay((Object[])new Object[]{this.handler});
        this.servlet.doGet(request, response);
        EasyMock.verify((Object[])new Object[]{response});
    }

    public void testDoGetWithHandlerRpcException() throws Exception {
        HttpServletRequest request = this.createGetRequest("{\"gadgets\":[]}", "function");
        HttpServletResponse response = this.createHttpResponse("rpcExceptionMessage", 500);
        org.easymock.EasyMock.expect((Object)this.handler.process((JSONObject)org.easymock.EasyMock.isA(JSONObject.class))).andThrow((Throwable)new RpcException("rpcExceptionMessage"));
        EasyMock.replay((Object[])new Object[]{this.handler});
        this.servlet.doGet(request, response);
        EasyMock.verify((Object[])new Object[]{response});
    }

    public void testDoGetWithHandlerJsonException() throws Exception {
        HttpServletRequest request = this.createGetRequest("{\"gadgets\":[]}", "function");
        HttpServletResponse response = this.createHttpResponse("Malformed JSON request.", 400);
        org.easymock.EasyMock.expect((Object)this.handler.process((JSONObject)org.easymock.EasyMock.isA(JSONObject.class))).andThrow((Throwable)new JSONException("json"));
        EasyMock.replay((Object[])new Object[]{this.handler});
        this.servlet.doGet(request, response);
        EasyMock.verify((Object[])new Object[]{response});
    }

    public void testDoGetWithMissingReqParam() throws Exception {
        HttpServletRequest request = this.createGetRequest(null, "function");
        HttpServletResponse response = this.createHttpResponse(null, 400);
        this.servlet.doGet(request, response);
        EasyMock.verify((Object[])new Object[]{response});
    }

    public void testDoGetWithMissingCallbackParam() throws Exception {
        HttpServletRequest request = this.createGetRequest("{\"gadgets\":[]}", null);
        HttpServletResponse response = this.createHttpResponse(null, 400);
        this.servlet.doGet(request, response);
        EasyMock.verify((Object[])new Object[]{response});
    }

    public void testDoGetWithBadCallbackParamValue() throws Exception {
        HttpServletRequest request = this.createGetRequest("{\"gadgets\":[]}", "/'!=");
        HttpServletResponse response = this.createHttpResponse(null, 400);
        this.servlet.doGet(request, response);
        EasyMock.verify((Object[])new Object[]{response});
    }

    private HttpServletRequest createGetRequest(String reqParamValue, String callbackParamValue) {
        HttpServletRequest result = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        org.easymock.EasyMock.expect((Object)result.getMethod()).andReturn((Object)"GET").anyTimes();
        org.easymock.EasyMock.expect((Object)result.getCharacterEncoding()).andReturn((Object)"UTF-8").anyTimes();
        org.easymock.EasyMock.expect((Object)result.getParameter("req")).andReturn((Object)reqParamValue).anyTimes();
        org.easymock.EasyMock.expect((Object)result.getParameter("callback")).andReturn((Object)callbackParamValue).anyTimes();
        EasyMock.replay((Object[])new Object[]{result});
        return result;
    }

    private HttpServletResponse createHttpResponse(String response, int httpStatusCode) throws IOException {
        return this.createHttpResponse(null, null, null, response, httpStatusCode);
    }

    private HttpServletResponse createHttpResponse(String header1, String header2, String contentType, String response, int httpStatusCode) throws IOException {
        HttpServletResponse result = (HttpServletResponse)EasyMock.createMock(HttpServletResponse.class);
        PrintWriter writer = (PrintWriter)EasyMock.createMock(PrintWriter.class);
        if (response != null) {
            org.easymock.EasyMock.expect((Object)result.getWriter()).andReturn((Object)writer);
            writer.write(response);
        }
        if (header1 != null && header2 != null) {
            result.setHeader(header1, header2);
        }
        if (contentType != null) {
            result.setContentType(contentType);
        }
        result.setStatus(httpStatusCode);
        EasyMock.replay((Object[])new Object[]{result, writer});
        return result;
    }
}

