/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import java.util.Locale;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.Icon;
import org.apache.shindig.gadgets.spec.LinkSpec;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.apache.shindig.gadgets.spec.ModulePrefs;
import org.apache.shindig.gadgets.spec.OAuthService;
import org.apache.shindig.gadgets.spec.Preload;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.gadgets.variables.Substitutions;
import org.junit.Assert;
import org.junit.Test;

public class ModulePrefsTest {
    private static final Uri SPEC_URL = Uri.parse((String)"http://example.org/g.xml");
    private static final String FULL_XML = "<ModulePrefs title='title' title_url='title_url' description='description' author='author' author_email='author_email' screenshot='screenshot' thumbnail='thumbnail' directory_title='directory_title' width='1' height='2' scrolling='true' category='category' category2='category2' author_affiliation='author_affiliation' author_location='author_location' author_photo='author_photo' author_aboutme='author_aboutme' author_quote='author_quote' author_link='author_link' show_stats='true' show_in_directory='true' singleton='true'>  <Require feature='require'/>  <Optional feature='optional'/>  <Preload href='http://example.org' authz='signed'/>  <Icon/>  <Locale/>  <Link rel='link' href='http://example.org/link'/>  <OAuth>    <Service name='serviceOne'>      <Request url='http://www.example.com/request'          method='GET' param_location='auth-header' />      <Authorization url='http://www.example.com/authorize'/>      <Access url='http://www.example.com/access' method='GET'          param_location='auth-header' />    </Service>  </OAuth></ModulePrefs>";

    private void doAsserts(ModulePrefs prefs) {
        Assert.assertEquals((Object)"title", (Object)prefs.getTitle());
        Assert.assertEquals((Object)SPEC_URL.resolve(Uri.parse((String)"title_url")), (Object)prefs.getTitleUrl());
        Assert.assertEquals((Object)"description", (Object)prefs.getDescription());
        Assert.assertEquals((Object)"author", (Object)prefs.getAuthor());
        Assert.assertEquals((Object)"author_email", (Object)prefs.getAuthorEmail());
        Assert.assertEquals((Object)SPEC_URL.resolve(Uri.parse((String)"screenshot")), (Object)prefs.getScreenshot());
        Assert.assertEquals((Object)SPEC_URL.resolve(Uri.parse((String)"thumbnail")), (Object)prefs.getThumbnail());
        Assert.assertEquals((Object)"directory_title", (Object)prefs.getDirectoryTitle());
        Assert.assertEquals((long)1L, (long)prefs.getWidth());
        Assert.assertEquals((long)2L, (long)prefs.getHeight());
        Assert.assertTrue((boolean)prefs.getScrolling());
        Assert.assertFalse((boolean)prefs.getScaling());
        Assert.assertEquals((Object)"category", prefs.getCategories().get(0));
        Assert.assertEquals((Object)"category2", prefs.getCategories().get(1));
        Assert.assertEquals((Object)"author_affiliation", (Object)prefs.getAuthorAffiliation());
        Assert.assertEquals((Object)"author_location", (Object)prefs.getAuthorLocation());
        Assert.assertEquals((Object)SPEC_URL.resolve(Uri.parse((String)"author_photo")), (Object)prefs.getAuthorPhoto());
        Assert.assertEquals((Object)SPEC_URL.resolve(Uri.parse((String)"author_link")), (Object)prefs.getAuthorLink());
        Assert.assertEquals((Object)"author_aboutme", (Object)prefs.getAuthorAboutme());
        Assert.assertEquals((Object)"author_quote", (Object)prefs.getAuthorQuote());
        Assert.assertEquals((Object)true, (Object)prefs.getShowStats());
        Assert.assertEquals((Object)true, (Object)prefs.getShowInDirectory());
        Assert.assertEquals((Object)true, (Object)prefs.getSingleton());
        Assert.assertEquals((Object)true, (Object)((Feature)prefs.getFeatures().get("require")).getRequired());
        Assert.assertEquals((Object)false, (Object)((Feature)prefs.getFeatures().get("optional")).getRequired());
        Assert.assertEquals((Object)"http://example.org", (Object)((Preload)prefs.getPreloads().get(0)).getHref().toString());
        Assert.assertEquals((long)1L, (long)prefs.getIcons().size());
        Assert.assertEquals((long)1L, (long)prefs.getLocales().size());
        Assert.assertEquals((Object)Uri.parse((String)"http://example.org/link"), (Object)((LinkSpec)prefs.getLinks().get("link")).getHref());
        OAuthService oauth = (OAuthService)prefs.getOAuthSpec().getServices().get("serviceOne");
        Assert.assertEquals((Object)Uri.parse((String)"http://www.example.com/request"), (Object)oauth.getRequestUrl().url);
        Assert.assertEquals((Object)OAuthService.Method.GET, (Object)oauth.getRequestUrl().method);
        Assert.assertEquals((Object)OAuthService.Method.GET, (Object)oauth.getAccessUrl().method);
        Assert.assertEquals((Object)OAuthService.Location.HEADER, (Object)oauth.getAccessUrl().location);
        Assert.assertEquals((Object)Uri.parse((String)"http://www.example.com/authorize"), (Object)oauth.getAuthorizationUrl());
    }

    @Test
    public void basicElementsParseOk() throws Exception {
        this.doAsserts(new ModulePrefs(XmlUtil.parse((String)FULL_XML), SPEC_URL));
    }

    @Test
    public void getAttribute() throws Exception {
        String xml = "<ModulePrefs title='title' some_attribute='attribute' empty_attribute=''/>";
        ModulePrefs prefs = new ModulePrefs(XmlUtil.parse((String)xml), SPEC_URL);
        Assert.assertEquals((Object)"title", (Object)prefs.getAttribute("title"));
        Assert.assertEquals((Object)"attribute", (Object)prefs.getAttribute("some_attribute"));
        Assert.assertEquals((Object)"", (Object)prefs.getAttribute("empty_attribute"));
        Assert.assertNull((Object)prefs.getAttribute("gobbledygook"));
    }

    @Test
    public void getLocale() throws Exception {
        String xml = "<ModulePrefs title='locales'>  <Locale lang='en' messages='en.xml'/>  <Locale lang='foo' language_direction='rtl'/></ModulePrefs>";
        ModulePrefs prefs = new ModulePrefs(XmlUtil.parse((String)xml), SPEC_URL);
        LocaleSpec spec = prefs.getLocale(new Locale("en", "uk"));
        Assert.assertEquals((Object)"http://example.org/en.xml", (Object)spec.getMessages().toString());
        spec = prefs.getLocale(new Locale("foo", "bar"));
        Assert.assertEquals((Object)"rtl", (Object)spec.getLanguageDirection());
    }

    @Test
    public void getLinks() throws Exception {
        String link1Rel = "foo";
        String link2Rel = "bar";
        Uri link1Href = Uri.parse((String)"http://example.org/foo");
        Uri link2Href = Uri.parse((String)"/bar");
        String xml = "<ModulePrefs title='links'>  <Link rel='" + link1Rel + "' href='" + link1Href + "'/>" + "  <Link rel='" + link2Rel + "' href='" + link2Href + "'/>" + "</ModulePrefs>";
        ModulePrefs prefs = new ModulePrefs(XmlUtil.parse((String)xml), SPEC_URL).substitute(new Substitutions());
        Assert.assertEquals((Object)link1Href, (Object)((LinkSpec)prefs.getLinks().get(link1Rel)).getHref());
        Assert.assertEquals((Object)SPEC_URL.resolve(link2Href), (Object)((LinkSpec)prefs.getLinks().get(link2Rel)).getHref());
    }

    @Test
    public void doSubstitution() throws Exception {
        String xml = "<ModulePrefs title='__MSG_title__'>  <Icon>__MSG_icon__</Icon>  <Link rel='__MSG_rel__' href='__MSG_link_href__'/>  <Preload href='__MSG_pre_href__'/></ModulePrefs>";
        String title = "blah";
        String icon = "http://example.org/icon.gif";
        String rel = "foo-bar";
        String linkHref = "http://example.org/link.html";
        String preHref = "http://example.org/preload.html";
        ModulePrefs prefs = new ModulePrefs(XmlUtil.parse((String)xml), SPEC_URL);
        Substitutions subst = new Substitutions();
        subst.addSubstitution(Substitutions.Type.MESSAGE, "title", title);
        subst.addSubstitution(Substitutions.Type.MESSAGE, "icon", icon);
        subst.addSubstitution(Substitutions.Type.MESSAGE, "rel", rel);
        subst.addSubstitution(Substitutions.Type.MESSAGE, "link_href", linkHref);
        subst.addSubstitution(Substitutions.Type.MESSAGE, "pre_href", preHref);
        prefs = prefs.substitute(subst);
        Assert.assertEquals((Object)title, (Object)prefs.getTitle());
        Assert.assertEquals((Object)icon, (Object)((Icon)prefs.getIcons().get(0)).getContent());
        Assert.assertEquals((Object)rel, (Object)((LinkSpec)prefs.getLinks().get(rel)).getRel());
        Assert.assertEquals((Object)linkHref, (Object)((LinkSpec)prefs.getLinks().get(rel)).getHref().toString());
        Assert.assertEquals((Object)preHref, (Object)((Preload)prefs.getPreloads().get(0)).getHref().toString());
    }

    @Test
    public void malformedIntAttributeTreatedAsZero() throws Exception {
        String xml = "<ModulePrefs title='' height='100px' width='foobar' arbitrary='0xff'/>";
        ModulePrefs prefs = new ModulePrefs(XmlUtil.parse((String)xml), SPEC_URL);
        Assert.assertEquals((long)0L, (long)prefs.getHeight());
        Assert.assertEquals((long)0L, (long)prefs.getWidth());
        Assert.assertEquals((long)0L, (long)prefs.getIntAttribute("arbitrary"));
    }

    @Test(expected=SpecParserException.class)
    public void missingTitleThrows() throws Exception {
        String xml = "<ModulePrefs/>";
        new ModulePrefs(XmlUtil.parse((String)xml), SPEC_URL);
    }

    @Test
    public void toStringIsSane() throws Exception {
        ModulePrefs prefs = new ModulePrefs(XmlUtil.parse((String)FULL_XML), SPEC_URL);
        this.doAsserts(new ModulePrefs(XmlUtil.parse((String)prefs.toString()), SPEC_URL));
    }
}

