/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import junit.framework.TestCase;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.gadgets.spec.UserPref;
import org.apache.shindig.gadgets.variables.Substitutions;

public class UserPrefTest
extends TestCase {
    public void testBasic() throws Exception {
        String xml = "<UserPref name=\"name\" display_name=\"display_name\" default_value=\"default_value\" required=\"true\" datatype=\"hidden\"/>";
        UserPref userPref = new UserPref(XmlUtil.parse((String)xml));
        UserPrefTest.assertEquals((String)"name", (String)userPref.getName());
        UserPrefTest.assertEquals((String)"display_name", (String)userPref.getDisplayName());
        UserPrefTest.assertEquals((String)"default_value", (String)userPref.getDefaultValue());
        UserPrefTest.assertEquals((boolean)true, (boolean)userPref.getRequired());
        UserPrefTest.assertEquals((Object)UserPref.DataType.HIDDEN, (Object)userPref.getDataType());
    }

    public void testEnum() throws Exception {
        String xml = "<UserPref name=\"foo\" datatype=\"enum\"> <EnumValue value=\"0\" display_value=\"Zero\"/> <EnumValue value=\"1\"/></UserPref>";
        UserPref userPref = new UserPref(XmlUtil.parse((String)xml));
        UserPrefTest.assertEquals((int)2, (int)userPref.getEnumValues().size());
        UserPrefTest.assertEquals((String)"Zero", (String)((String)userPref.getEnumValues().get("0")));
        UserPrefTest.assertEquals((String)"1", (String)((String)userPref.getEnumValues().get("1")));
    }

    public void testSubstitutions() throws Exception {
        String xml = "<UserPref name=\"name\" datatype=\"enum\" display_name=\"__MSG_display_name__\" default_value=\"__MSG_default_value__\"> <EnumValue value=\"0\" display_value=\"__MSG_dv__\"/></UserPref>";
        String displayName = "This is the display name";
        String defaultValue = "This is the default value";
        String displayValue = "This is the display value";
        Substitutions substituter = new Substitutions();
        substituter.addSubstitution(Substitutions.Type.MESSAGE, "display_name", displayName);
        substituter.addSubstitution(Substitutions.Type.MESSAGE, "default_value", defaultValue);
        substituter.addSubstitution(Substitutions.Type.MESSAGE, "dv", displayValue);
        UserPref userPref = new UserPref(XmlUtil.parse((String)xml)).substitute(substituter);
        UserPrefTest.assertEquals((String)displayName, (String)userPref.getDisplayName());
        UserPrefTest.assertEquals((String)defaultValue, (String)userPref.getDefaultValue());
        UserPrefTest.assertEquals((String)displayValue, (String)((String)userPref.getEnumValues().get("0")));
    }

    public void testMissingName() throws Exception {
        String xml = "<UserPref datatype=\"string\"/>";
        try {
            new UserPref(XmlUtil.parse((String)xml));
            UserPrefTest.fail((String)"No exception thrown when name is missing");
        }
        catch (SpecParserException specParserException) {
            // empty catch block
        }
    }

    public void testMissingDataType() throws Exception {
        String xml = "<UserPref name=\"name\"/>";
        UserPref pref = new UserPref(XmlUtil.parse((String)xml));
        UserPrefTest.assertEquals((Object)UserPref.DataType.STRING, (Object)pref.getDataType());
    }

    public void testMissingEnumValue() throws Exception {
        String xml = "<UserPref name=\"foo\" datatype=\"enum\"> <EnumValue/></UserPref>";
        try {
            new UserPref(XmlUtil.parse((String)xml));
            UserPrefTest.fail((String)"No exception thrown when EnumValue@value is missing");
        }
        catch (SpecParserException specParserException) {
            // empty catch block
        }
    }
}

