/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.variables;

import junit.framework.TestCase;
import org.apache.shindig.gadgets.variables.BidiSubstituter;
import org.apache.shindig.gadgets.variables.Substitutions;

public class BidiSubstituterTest
extends TestCase {
    public void testBidiWithRtl() {
        this.assertRightToLeft("rtl");
    }

    public void testBidiWithLtr() {
        this.assertLeftToRight("ltr");
    }

    public void testBidiWithEmpty() {
        this.assertLeftToRight("");
    }

    public void testBidiWithNull() {
        this.assertLeftToRight(null);
    }

    private void assertRightToLeft(String direction) {
        this.assertSubstitutions(direction, "right", "left", "rtl", "ltr");
    }

    private void assertLeftToRight(String direction) {
        this.assertSubstitutions(direction, "left", "right", "ltr", "rtl");
    }

    private void assertSubstitutions(String direction, String startEdge, String endEdge, String dir, String reverseDir) {
        Substitutions substitutions = new Substitutions();
        BidiSubstituter.addSubstitutions((Substitutions)substitutions, (String)direction);
        BidiSubstituterTest.assertEquals((String)startEdge, (String)substitutions.getSubstitution(Substitutions.Type.BIDI, "START_EDGE"));
        BidiSubstituterTest.assertEquals((String)endEdge, (String)substitutions.getSubstitution(Substitutions.Type.BIDI, "END_EDGE"));
        BidiSubstituterTest.assertEquals((String)dir, (String)substitutions.getSubstitution(Substitutions.Type.BIDI, "DIR"));
        BidiSubstituterTest.assertEquals((String)reverseDir, (String)substitutions.getSubstitution(Substitutions.Type.BIDI, "REVERSE_DIR"));
    }
}

