/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.ResourceLoader;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;

public final class JsLibrary {
    private final Type type;
    private final String content;
    private final String debugContent;
    private final String feature;
    private static final Logger logger = Logger.getLogger("org.apache.shindig.gadgets");

    public Type getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public String getDebugContent() {
        return this.debugContent;
    }

    public String getFeature() {
        return this.feature;
    }

    public String toString() {
        if (this.type == Type.URL) {
            return "<script src=\"" + this.content + "\"></script>";
        }
        return "<script><!--\n" + this.content + "\n--></script>";
    }

    public static JsLibrary create(Type type, String content, String feature, HttpFetcher fetcher) throws GadgetException {
        String debugContent;
        String optimizedContent = null;
        switch (type) {
            case FILE: 
            case RESOURCE: {
                if (content.endsWith(".js")) {
                    optimizedContent = JsLibrary.loadData(content.substring(0, content.length() - 3) + ".opt.js", type);
                }
                debugContent = JsLibrary.loadData(content, type);
                if (optimizedContent != null && optimizedContent.length() != 0) break;
                optimizedContent = debugContent;
                break;
            }
            case URL: {
                if (fetcher == null) {
                    debugContent = optimizedContent = content;
                    break;
                }
                type = Type.FILE;
                debugContent = optimizedContent = JsLibrary.loadDataFromUrl(content, fetcher);
                break;
            }
            default: {
                debugContent = content;
                optimizedContent = content;
            }
        }
        return new JsLibrary(feature, type, optimizedContent, debugContent);
    }

    private static String loadData(String name, Type type) {
        logger.info("Loading js from: " + name + " type: " + type.toString());
        if (type == Type.FILE) {
            return JsLibrary.loadFile(name);
        }
        if (type == Type.RESOURCE) {
            return JsLibrary.loadResource(name);
        }
        return null;
    }

    private static String loadDataFromUrl(String url, HttpFetcher fetcher) throws GadgetException {
        try {
            logger.info("Attempting to load js from: " + url);
            Uri uri = Uri.parse((String)url);
            HttpRequest request = new HttpRequest(uri);
            HttpResponse response = fetcher.fetch(request);
            if (response.getHttpStatusCode() == 200) {
                return response.getResponseAsString();
            }
            logger.warning("Unable to retrieve remote library from " + url);
            return null;
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.WARNING, "Malformed URL: " + url, e);
            return null;
        }
    }

    private static String loadFile(String fileName) {
        if (fileName == null) {
            return "";
        }
        File file = new File(fileName);
        if (!file.exists()) {
            logger.warning("File not found: " + fileName);
            return null;
        }
        if (!file.isFile()) {
            logger.warning("JsLibrary is not a file: " + fileName);
            return null;
        }
        if (!file.canRead()) {
            logger.warning("JsLibrary cannot be read: " + fileName);
            return null;
        }
        try {
            return ResourceLoader.getContent((File)file);
        }
        catch (IOException e) {
            logger.warning("Error reading file: " + fileName);
            return null;
        }
    }

    private static String loadResource(String name) {
        try {
            return ResourceLoader.getContent((String)name);
        }
        catch (IOException e) {
            logger.warning("Could not find resource: " + name);
            return null;
        }
    }

    public int hashCode() {
        return this.content.hashCode() + this.type.hashCode();
    }

    public boolean equals(Object rhs) {
        if (rhs == this) {
            return true;
        }
        if (rhs instanceof JsLibrary) {
            JsLibrary lib = (JsLibrary)rhs;
            return this.content.equals(lib.content) && this.type.equals((Object)lib.type);
        }
        return false;
    }

    private JsLibrary(String feature, Type type, String content, String debugContent) {
        this.feature = feature;
        this.type = type;
        this.content = content;
        this.debugContent = debugContent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        FILE,
        RESOURCE,
        URL,
        INLINE;


        public static Type parse(String name) {
            if ("file".equals(name)) {
                return FILE;
            }
            if ("url".equals(name)) {
                return URL;
            }
            if ("resource".equals(name)) {
                return RESOURCE;
            }
            return INLINE;
        }
    }
}

