/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.spec.RequestAuthenticationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthArguments {
    private static final String SERVICE_PARAM = "OAUTH_SERVICE_NAME";
    private static final String TOKEN_PARAM = "OAUTH_TOKEN_NAME";
    private static final String REQUEST_TOKEN_PARAM = "OAUTH_REQUEST_TOKEN";
    private static final String REQUEST_TOKEN_SECRET_PARAM = "OAUTH_REQUEST_TOKEN_SECRET";
    private static final String USE_TOKEN_PARAM = "OAUTH_USE_TOKEN";
    private static final String CLIENT_STATE_PARAM = "oauthState";
    private static final String BYPASS_SPEC_CACHE_PARAM = "bypassSpecCache";
    private static final String SIGN_OWNER_PARAM = "signOwner";
    private static final String SIGN_VIEWER_PARAM = "signViewer";
    private UseToken useToken = UseToken.ALWAYS;
    private String serviceName = "";
    private String tokenName = "";
    private String requestToken = null;
    private String requestTokenSecret = null;
    private String origClientState = null;
    private boolean bypassSpecCache = false;
    private boolean signOwner = false;
    private boolean signViewer = false;

    public OAuthArguments(AuthType auth, HttpServletRequest request) throws GadgetException {
        this.useToken = OAuthArguments.parseUseToken(auth, OAuthArguments.getRequestParam(request, USE_TOKEN_PARAM, ""));
        this.serviceName = OAuthArguments.getRequestParam(request, SERVICE_PARAM, "");
        this.tokenName = OAuthArguments.getRequestParam(request, TOKEN_PARAM, "");
        this.requestToken = OAuthArguments.getRequestParam(request, REQUEST_TOKEN_PARAM, null);
        this.requestTokenSecret = OAuthArguments.getRequestParam(request, REQUEST_TOKEN_SECRET_PARAM, null);
        this.origClientState = OAuthArguments.getRequestParam(request, CLIENT_STATE_PARAM, null);
        this.bypassSpecCache = "1".equals(OAuthArguments.getRequestParam(request, BYPASS_SPEC_CACHE_PARAM, null));
        this.signOwner = Boolean.parseBoolean(OAuthArguments.getRequestParam(request, SIGN_OWNER_PARAM, "true"));
        this.signViewer = Boolean.parseBoolean(OAuthArguments.getRequestParam(request, SIGN_VIEWER_PARAM, "true"));
    }

    public OAuthArguments(RequestAuthenticationInfo info) throws GadgetException {
        TreeMap attrs = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        attrs.putAll(info.getAttributes());
        this.useToken = OAuthArguments.parseUseToken(info.getAuthType(), OAuthArguments.getAuthInfoParam(attrs, USE_TOKEN_PARAM, ""));
        this.serviceName = OAuthArguments.getAuthInfoParam(attrs, SERVICE_PARAM, "");
        this.tokenName = OAuthArguments.getAuthInfoParam(attrs, TOKEN_PARAM, "");
        this.requestToken = OAuthArguments.getAuthInfoParam(attrs, REQUEST_TOKEN_PARAM, null);
        this.requestTokenSecret = OAuthArguments.getAuthInfoParam(attrs, REQUEST_TOKEN_SECRET_PARAM, null);
        this.origClientState = null;
        this.bypassSpecCache = false;
        this.signOwner = info.isSignOwner();
        this.signViewer = info.isSignViewer();
    }

    private static String getAuthInfoParam(Map<String, String> attrs, String name, String def) {
        String val = attrs.get(name);
        if (val == null) {
            val = def;
        }
        return val;
    }

    private static String getRequestParam(HttpServletRequest request, String name, String def) {
        String val = request.getParameter(name);
        if (val == null) {
            val = def;
        }
        return val;
    }

    private static UseToken parseUseToken(AuthType auth, String useTokenStr) throws GadgetException {
        if (useTokenStr.length() == 0) {
            if (auth == AuthType.SIGNED) {
                return UseToken.NEVER;
            }
            return UseToken.ALWAYS;
        }
        if ("always".equals(useTokenStr = useTokenStr.toLowerCase())) {
            return UseToken.ALWAYS;
        }
        if ("if_available".equals(useTokenStr)) {
            return UseToken.IF_AVAILABLE;
        }
        if ("never".equals(useTokenStr)) {
            return UseToken.NEVER;
        }
        throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "Unknown use token value " + useTokenStr);
    }

    public OAuthArguments() {
    }

    public OAuthArguments(OAuthArguments orig) {
        this.useToken = orig.useToken;
        this.serviceName = orig.serviceName;
        this.tokenName = orig.tokenName;
        this.requestToken = orig.requestToken;
        this.requestTokenSecret = orig.requestTokenSecret;
        this.origClientState = orig.origClientState;
        this.bypassSpecCache = orig.bypassSpecCache;
        this.signOwner = orig.signOwner;
        this.signViewer = orig.signViewer;
    }

    public boolean mustUseToken() {
        return this.useToken == UseToken.ALWAYS;
    }

    public boolean mayUseToken() {
        return this.useToken == UseToken.IF_AVAILABLE || this.useToken == UseToken.ALWAYS;
    }

    public UseToken getUseToken() {
        return this.useToken;
    }

    public void setUseToken(UseToken useToken) {
        this.useToken = useToken;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

    public String getRequestToken() {
        return this.requestToken;
    }

    public void setRequestToken(String requestToken) {
        this.requestToken = requestToken;
    }

    public String getRequestTokenSecret() {
        return this.requestTokenSecret;
    }

    public void setRequestTokenSecret(String requestTokenSecret) {
        this.requestTokenSecret = requestTokenSecret;
    }

    public String getOrigClientState() {
        return this.origClientState;
    }

    public void setOrigClientState(String origClientState) {
        this.origClientState = origClientState;
    }

    public boolean getBypassSpecCache() {
        return this.bypassSpecCache;
    }

    public void setBypassSpecCache(boolean bypassSpecCache) {
        this.bypassSpecCache = bypassSpecCache;
    }

    public boolean getSignOwner() {
        return this.signOwner;
    }

    public void setSignOwner(boolean signOwner) {
        this.signOwner = signOwner;
    }

    public boolean getSignViewer() {
        return this.signViewer;
    }

    public void setSignViewer(boolean signViewer) {
        this.signViewer = signViewer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UseToken {
        NEVER,
        IF_AVAILABLE,
        ALWAYS;

    }
}

