/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.caja;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.HtmlLexer;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.TokenQueue;
import com.google.caja.lexer.TokenStream;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.DomTree;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.util.Name;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.HtmlSerializer;
import org.apache.xml.serialize.HTMLSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Singleton
public class CajaHtmlParser
extends GadgetHtmlParser {
    private final DOMImplementation documentProvider;

    @Inject
    public CajaHtmlParser(DOMImplementation documentProvider) {
        this.documentProvider = documentProvider;
    }

    public Document parseDomImpl(String source) throws GadgetException {
        Document document = this.makeDocument(this.getFragment(source));
        HtmlSerializer.attach(document, new Serializer(), source);
        return document;
    }

    DomTree.Fragment getFragment(String content) throws GadgetException {
        DomParser parser = this.getParser(content);
        try {
            return parser.parseFragment();
        }
        catch (ParseException pe) {
            try {
                DomTree.Fragment fragment = this.getParser("<HTML>" + content + "</HTML>").parseFragment();
                return new DomTree.Fragment(((DomTree)fragment.children().get(0)).children());
            }
            catch (ParseException pe2) {
                throw new GadgetException(GadgetException.Code.HTML_PARSE_ERROR, (Throwable)pe2);
            }
        }
    }

    DomParser getParser(String content) {
        InputSource source = null;
        try {
            source = new InputSource(new URI("http://dummy.com/"));
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        CharProducer producer = CharProducer.Factory.create((Reader)new StringReader(content), (InputSource)source);
        HtmlLexer lexer = new HtmlLexer(producer);
        SimpleMessageQueue mQueue = new SimpleMessageQueue();
        return new DomParser(new TokenQueue((TokenStream)lexer, source), false, (MessageQueue)mQueue);
    }

    private Document makeDocument(DomTree.Fragment fragment) {
        Document htmlDocument = this.documentProvider.createDocument(null, null, null);
        for (DomTree node : fragment.children()) {
            if (!(node instanceof DomTree.Tag) || !((DomTree.Tag)node).getTagName().equals((Object)Name.html((String)"HTML"))) continue;
            CajaHtmlParser.recurseDocument(htmlDocument, htmlDocument, node);
            return htmlDocument;
        }
        Node root = htmlDocument.appendChild(htmlDocument.createElement("HTML"));
        for (DomTree child : fragment.children()) {
            CajaHtmlParser.recurseDocument(htmlDocument, root, child);
        }
        return htmlDocument;
    }

    private static void recurseDocument(Document doc, Node parent, DomTree elem) {
        if (elem instanceof DomTree.Tag) {
            DomTree.Tag tag = (DomTree.Tag)elem;
            Element element = doc.createElement(tag.getTagName().getCanonicalForm());
            parent.appendChild(element);
            for (DomTree child : elem.children()) {
                CajaHtmlParser.recurseDocument(doc, element, child);
            }
        } else if (elem instanceof DomTree.Attrib) {
            DomTree.Attrib attrib = (DomTree.Attrib)elem;
            Attr domAttrib = doc.createAttribute(attrib.getAttribName().getCanonicalForm());
            parent.getAttributes().setNamedItem(domAttrib);
            domAttrib.setValue(attrib.getAttribValue());
        } else if (elem instanceof DomTree.Text) {
            parent.appendChild(doc.createTextNode(elem.getValue()));
        } else if (elem instanceof DomTree.CData) {
            parent.appendChild(doc.createCDATASection(elem.getValue()));
        }
    }

    static class Serializer
    extends HtmlSerializer {
        static final OutputFormat outputFormat = new OutputFormat();

        Serializer() {
        }

        public String serializeImpl(Document doc) {
            StringWriter sw = Serializer.createWriter(doc);
            HTMLSerializer serializer = new HTMLSerializer((Writer)sw, outputFormat);
            try {
                serializer.serialize(doc);
                return sw.toString();
            }
            catch (IOException ioe) {
                return null;
            }
        }

        static {
            outputFormat.setPreserveSpace(true);
            outputFormat.setPreserveEmptyAttributes(false);
        }
    }
}

