/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.UrlGenerator;
import org.apache.shindig.gadgets.process.ProcessingException;
import org.apache.shindig.gadgets.process.Processor;
import org.apache.shindig.gadgets.servlet.JsonRpcGadgetContext;
import org.apache.shindig.gadgets.servlet.RpcException;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.LinkSpec;
import org.apache.shindig.gadgets.spec.ModulePrefs;
import org.apache.shindig.gadgets.spec.UserPref;
import org.apache.shindig.gadgets.spec.View;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonRpcHandler {
    private final ExecutorService executor;
    private final Processor processor;
    private final UrlGenerator urlGenerator;

    @Inject
    public JsonRpcHandler(ExecutorService executor, Processor processor, UrlGenerator urlGenerator) {
        this.executor = executor;
        this.processor = processor;
        this.urlGenerator = urlGenerator;
    }

    public JSONObject process(JSONObject request) throws RpcException, JSONException {
        JSONObject requestContext = request.getJSONObject("context");
        JSONArray requestedGadgets = request.getJSONArray("gadgets");
        ArrayList gadgets = Lists.newArrayListWithExpectedSize((int)requestedGadgets.length());
        int j = requestedGadgets.length();
        for (int i = 0; i < j; ++i) {
            GadgetContext context = new JsonRpcGadgetContext(requestContext, requestedGadgets.getJSONObject(i));
            gadgets.add(context);
        }
        ExecutorCompletionService<JSONObject> processor = new ExecutorCompletionService<JSONObject>(this.executor);
        for (GadgetContext context : gadgets) {
            processor.submit(new Job(context));
        }
        JSONObject response = new JSONObject();
        int numJobs = gadgets.size();
        do {
            try {
                JSONObject gadget = (JSONObject)processor.take().get();
                response.append("gadgets", (Object)gadget);
            }
            catch (InterruptedException e) {
                throw new RpcException("Processing interrupted", (Throwable)e);
            }
            catch (ExecutionException ee) {
                if (!(ee.getCause() instanceof RpcException)) {
                    throw new RpcException("Processing interrupted", (Throwable)ee);
                }
                RpcException e = (RpcException)ee.getCause();
                try {
                    GadgetContext context = e.getContext();
                    JSONObject errorObj = new JSONObject();
                    errorObj.put("url", (Object)context.getUrl()).put("moduleId", context.getModuleId());
                    errorObj.append("errors", (Object)e.getCause().getLocalizedMessage());
                    response.append("gadgets", (Object)errorObj);
                }
                catch (JSONException je) {
                    throw new RpcException("Unable to write JSON", (Throwable)je);
                }
            }
            catch (JSONException e) {
                throw new RpcException("Unable to write JSON", (Throwable)e);
            }
            finally {
                --numJobs;
            }
        } while (numJobs > 0);
        return response;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Job
    implements Callable<JSONObject> {
        private final GadgetContext context;

        public Job(GadgetContext context) {
            this.context = context;
        }

        @Override
        public JSONObject call() throws RpcException {
            try {
                Gadget gadget = JsonRpcHandler.this.processor.process(this.context);
                GadgetSpec spec = gadget.getSpec();
                JSONObject gadgetJson = new JSONObject();
                ModulePrefs prefs = spec.getModulePrefs();
                JSONObject views = new JSONObject();
                for (View view : spec.getViews().values()) {
                    views.put(view.getName(), (Object)new JSONObject().put("type", (Object)view.getType().toString().toLowerCase()).put("quirks", view.getQuirks()).put("preferredHeight", view.getPreferredHeight()).put("preferredWidth", view.getPreferredWidth()));
                }
                Set<String> feats = prefs.getFeatures().keySet();
                String[] features = feats.toArray(new String[feats.size()]);
                JSONObject links = new JSONObject();
                for (LinkSpec link : prefs.getLinks().values()) {
                    links.put(link.getRel(), (Object)link.getHref());
                }
                JSONObject userPrefs = new JSONObject();
                for (UserPref pref : spec.getUserPrefs()) {
                    JSONObject up = new JSONObject().put("displayName", (Object)pref.getDisplayName()).put("type", (Object)pref.getDataType().toString().toLowerCase()).put("default", (Object)pref.getDefaultValue()).put("enumValues", pref.getEnumValues()).put("orderedEnumValues", this.getOrderedEnums(pref));
                    userPrefs.put(pref.getName(), (Object)up);
                }
                gadgetJson.put("iframeUrl", (Object)JsonRpcHandler.this.urlGenerator.getIframeUrl(gadget)).put("url", (Object)this.context.getUrl().toString()).put("moduleId", this.context.getModuleId()).put("title", (Object)prefs.getTitle()).put("titleUrl", (Object)prefs.getTitleUrl().toString()).put("views", (Object)views).put("features", (Object)features).put("userPrefs", (Object)userPrefs).put("links", (Object)links).put("directoryTitle", (Object)prefs.getDirectoryTitle()).put("thumbnail", (Object)prefs.getThumbnail().toString()).put("screenshot", (Object)prefs.getScreenshot().toString()).put("author", (Object)prefs.getAuthor()).put("authorEmail", (Object)prefs.getAuthorEmail()).put("authorAffiliation", (Object)prefs.getAuthorAffiliation()).put("authorLocation", (Object)prefs.getAuthorLocation()).put("authorPhoto", (Object)prefs.getAuthorPhoto()).put("authorAboutme", (Object)prefs.getAuthorAboutme()).put("authorQuote", (Object)prefs.getAuthorQuote()).put("authorLink", (Object)prefs.getAuthorLink()).put("categories", prefs.getCategories()).put("screenshot", (Object)prefs.getScreenshot().toString()).put("height", prefs.getHeight()).put("width", prefs.getWidth()).put("showStats", prefs.getShowStats()).put("showInDirectory", prefs.getShowInDirectory()).put("singleton", prefs.getSingleton()).put("scaling", prefs.getScaling()).put("scrolling", prefs.getScrolling()).put("description", (Object)prefs.getDescription());
                return gadgetJson;
            }
            catch (ProcessingException e) {
                throw new RpcException(this.context, (Throwable)e);
            }
            catch (JSONException e) {
                throw new RpcException(this.context, (Throwable)e);
            }
        }

        private List<JSONObject> getOrderedEnums(UserPref pref) throws JSONException {
            List<UserPref.EnumValuePair> orderedEnums = pref.getOrderedEnumValues();
            ArrayList jsonEnums = Lists.newArrayListWithExpectedSize((int)orderedEnums.size());
            for (UserPref.EnumValuePair evp : orderedEnums) {
                JSONObject curEnum = new JSONObject();
                curEnum.put("value", (Object)evp.getValue());
                curEnum.put("displayValue", (Object)evp.getDisplayValue());
                jsonEnums.add(curEnum);
            }
            return jsonEnums;
        }
    }
}

