/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.servlet.MakeRequestHandler;

public class MakeRequestServlet
extends InjectedServlet {
    private static final Logger LOG = Logger.getLogger(MakeRequestServlet.class.getName());
    private MakeRequestHandler makeRequestHandler;

    @Inject
    public void setMakeRequestHandler(MakeRequestHandler makeRequestHandler) {
        this.makeRequestHandler = makeRequestHandler;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.makeRequestHandler.fetch(request, response);
        }
        catch (GadgetException e) {
            MakeRequestServlet.outputError(e, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doGet(request, response);
    }

    private static void outputError(GadgetException e, HttpServletResponse resp) throws IOException {
        LOG.log(Level.INFO, "makeRequest failed", e);
        resp.sendError(400, e.getMessage());
    }
}

