/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

public enum RenderingContext {
    GADGET("gadget", "0", false),
    CONFIGURED_GADGET("gadget", "2", true),
    CONTAINER("container", "1", true),
    METADATA("gadget", null, null),
    ALL("all", "3", true);

    private final String featureBundleTag;
    private final String paramValue;
    private final Boolean configurable;

    private RenderingContext(String featureXmlTag, String paramValue, Boolean configurable) {
        this.featureBundleTag = featureXmlTag;
        this.paramValue = paramValue;
        this.configurable = configurable;
    }

    public String getFeatureBundleTag() {
        return this.featureBundleTag;
    }

    public boolean isConfigurable() {
        return this.configurable;
    }

    public String getParamValue() {
        return this.paramValue;
    }

    public static RenderingContext valueOfParam(String param) {
        if (param != null) {
            for (RenderingContext rc : RenderingContext.values()) {
                String rcParam = rc.getParamValue();
                if (rcParam == null || !rcParam.equals(param)) continue;
                return rc;
            }
        }
        return RenderingContext.getDefault();
    }

    public static RenderingContext getDefault() {
        return GADGET;
    }
}

