/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.features;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.shindig.common.util.ResourceLoader;
import org.apache.shindig.gadgets.features.FeatureFile;

public class DefaultFeatureFile
implements FeatureFile {
    protected final File wrappedFile;

    public DefaultFeatureFile(String path) {
        this.wrappedFile = new File(path);
    }

    protected DefaultFeatureFile(File wrappedFile) {
        this.wrappedFile = wrappedFile;
    }

    protected DefaultFeatureFile createFile(File wrappedFile) {
        return new DefaultFeatureFile(wrappedFile);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.wrappedFile);
    }

    @Override
    public boolean canRead() {
        return this.wrappedFile.canRead();
    }

    @Override
    public boolean exists() {
        return this.wrappedFile.exists();
    }

    @Override
    public String getName() {
        return this.wrappedFile.getName();
    }

    @Override
    public String getPath() {
        return this.wrappedFile.getPath();
    }

    @Override
    public String getAbsolutePath() {
        return this.wrappedFile.getAbsolutePath();
    }

    @Override
    public boolean isDirectory() {
        return this.wrappedFile.isDirectory();
    }

    @Override
    public FeatureFile[] listFiles() {
        File[] wrappedFiles = this.wrappedFile.listFiles();
        if (wrappedFiles == null) {
            return null;
        }
        FeatureFile[] files = new FeatureFile[wrappedFiles.length];
        for (int i = 0; i < wrappedFiles.length; ++i) {
            files[i] = this.createFile(wrappedFiles[i]);
        }
        return files;
    }

    @Override
    public URI toURI() {
        return this.wrappedFile.toURI();
    }

    @Override
    public String getContent() throws IOException {
        return ResourceLoader.getContent((File)this.wrappedFile);
    }

    @Override
    public long lastModified() {
        return this.wrappedFile.lastModified();
    }
}

