/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.js;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureRegistryProvider;
import org.apache.shindig.gadgets.js.JsException;
import org.apache.shindig.gadgets.js.JsProcessor;
import org.apache.shindig.gadgets.js.JsRequest;
import org.apache.shindig.gadgets.js.JsResponseBuilder;
import org.apache.shindig.gadgets.uri.JsUriManager;

public class AddJslLoadedVariableProcessor
implements JsProcessor {
    private static final Logger LOG = Logger.getLogger(AddJslLoadedVariableProcessor.class.getName());
    private static final String CODE_ID = "[jsload-loaded-info]";
    @VisibleForTesting
    static final String TEMPLATE = "window['___jsl']['l'] = (window['___jsl']['l'] || []).concat(%s);";
    private final FeatureRegistryProvider featureRegistryProvider;

    @Inject
    public AddJslLoadedVariableProcessor(FeatureRegistryProvider featureRegistryProvider) {
        this.featureRegistryProvider = featureRegistryProvider;
    }

    @Override
    public boolean process(JsRequest jsRequest, JsResponseBuilder builder) throws JsException {
        FeatureRegistry registry;
        JsUriManager.JsUri jsUri;
        block3: {
            jsUri = jsRequest.getJsUri();
            registry = null;
            String repository = jsUri.getRepository();
            try {
                registry = this.featureRegistryProvider.get(jsUri.getRepository());
            }
            catch (GadgetException e) {
                if (!LOG.isLoggable(Level.WARNING)) break block3;
                LOG.log(Level.WARNING, "No registry found for repository: " + repository, e);
            }
        }
        if (registry != null && !jsUri.isNohint()) {
            Set<String> allfeatures = registry.getAllFeatureNames();
            TreeSet libs = Sets.newTreeSet();
            libs.addAll(jsUri.getLibs());
            libs.removeAll(jsUri.getLoadedLibs());
            libs.retainAll(allfeatures);
            String array = this.toArrayString(libs);
            builder.appendJs(String.format(TEMPLATE, array), CODE_ID, true);
        }
        return true;
    }

    private String toArrayString(Set<String> bundles) {
        StringBuilder builder = new StringBuilder();
        for (String bundle : bundles) {
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append('\'').append(StringEscapeUtils.escapeEcmaScript((String)bundle)).append('\'');
        }
        return '[' + builder.toString() + ']';
    }
}

