/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.js;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.HashSet;
import java.util.List;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.features.ApiDirective;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureRegistryProvider;
import org.apache.shindig.gadgets.features.FeatureResource;
import org.apache.shindig.gadgets.js.JsException;
import org.apache.shindig.gadgets.js.JsGadgetContext;
import org.apache.shindig.gadgets.js.JsProcessor;
import org.apache.shindig.gadgets.js.JsRequest;
import org.apache.shindig.gadgets.js.JsResponseBuilder;
import org.apache.shindig.gadgets.rewrite.js.JsCompiler;
import org.apache.shindig.gadgets.uri.JsUriManager;
import org.apache.shindig.gadgets.uri.UriStatus;

public class GetJsContentProcessor
implements JsProcessor {
    public static final int DEFAULT_VERSIONED_MAXAGE = -1;
    public static final int DEFAULT_UNVERSIONED_MAXAGE = 3600;
    public static final int DEFAULT_INVALID_MAXAGE = 0;
    private final FeatureRegistryProvider registryProvider;
    private final JsCompiler compiler;
    private int versionedMaxAge = -1;
    private int unversionedMaxAge = 3600;
    private int invalidMaxAge = 0;

    @Inject
    public GetJsContentProcessor(FeatureRegistryProvider registryProvider, JsCompiler compiler) {
        this.registryProvider = registryProvider;
        this.compiler = compiler;
    }

    @Inject(optional=true)
    public void setVersionedMaxAge(@Named(value="shindig.jscontent.versioned.maxage") Integer maxAge) {
        if (maxAge != null) {
            this.versionedMaxAge = maxAge;
        }
    }

    @Inject(optional=true)
    public void setUnversionedMaxAge(@Named(value="shindig.jscontent.unversioned.maxage") Integer maxAge) {
        if (maxAge != null) {
            this.unversionedMaxAge = maxAge;
        }
    }

    @Inject(optional=true)
    public void setInvalidMaxAge(@Named(value="shindig.jscontent.invalid.maxage") Integer maxAge) {
        if (maxAge != null) {
            this.invalidMaxAge = maxAge;
        }
    }

    @Override
    public boolean process(JsRequest request, JsResponseBuilder builder) throws JsException {
        FeatureRegistry registry;
        JsUriManager.JsUri jsUri = request.getJsUri();
        JsGadgetContext ctx = new JsGadgetContext(jsUri);
        try {
            registry = this.registryProvider.get(jsUri.getRepository());
        }
        catch (GadgetException e) {
            throw new JsException(e.getHttpStatusCode(), e.getMessage());
        }
        List<FeatureRegistry.FeatureBundle> requestedBundles = registry.getFeatureResources(ctx, jsUri.getLibs(), null).getBundles();
        List<FeatureRegistry.FeatureBundle> loadedBundles = registry.getFeatureResources(ctx, jsUri.getLoadedLibs(), null).getBundles();
        HashSet loadedFeatures = Sets.newHashSet();
        for (FeatureRegistry.FeatureBundle bundle : loadedBundles) {
            loadedFeatures.add(bundle.getName());
            builder.appendExterns(bundle.getApis(ApiDirective.Type.JS, true));
            builder.appendExterns(bundle.getApis(ApiDirective.Type.JS, false));
        }
        boolean isProxyCacheable = true;
        for (FeatureRegistry.FeatureBundle bundle : requestedBundles) {
            if (loadedFeatures.contains(bundle.getName())) continue;
            builder.appendAllJs(this.compiler.getJsContent(jsUri, bundle));
            for (FeatureResource featureResource : bundle.getResources()) {
                isProxyCacheable = isProxyCacheable && featureResource.isProxyCacheable();
            }
        }
        builder.setProxyCacheable(isProxyCacheable);
        UriStatus uriStatus = jsUri.getStatus();
        this.setResponseCacheTtl(builder, uriStatus != null ? uriStatus : UriStatus.VALID_UNVERSIONED);
        return true;
    }

    protected void setResponseCacheTtl(JsResponseBuilder builder, UriStatus vstatus) {
        switch (vstatus) {
            case VALID_VERSIONED: {
                builder.setCacheTtlSecs(this.versionedMaxAge);
                break;
            }
            case VALID_UNVERSIONED: {
                builder.setCacheTtlSecs(this.unversionedMaxAge);
                break;
            }
            case INVALID_VERSION: {
                builder.setCacheTtlSecs(this.invalidMaxAge);
            }
        }
    }
}

