/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Set;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.servlet.Authority;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.oauth2.BasicOAuth2Accessor;
import org.apache.shindig.gadgets.oauth2.OAuth2Accessor;
import org.apache.shindig.gadgets.oauth2.OAuth2CallbackState;
import org.apache.shindig.gadgets.oauth2.OAuth2Store;
import org.apache.shindig.gadgets.oauth2.OAuth2Token;
import org.apache.shindig.gadgets.oauth2.logger.FilteredLogger;
import org.apache.shindig.gadgets.oauth2.persistence.OAuth2Cache;
import org.apache.shindig.gadgets.oauth2.persistence.OAuth2CacheException;
import org.apache.shindig.gadgets.oauth2.persistence.OAuth2Client;
import org.apache.shindig.gadgets.oauth2.persistence.OAuth2Encrypter;
import org.apache.shindig.gadgets.oauth2.persistence.OAuth2PersistenceException;
import org.apache.shindig.gadgets.oauth2.persistence.OAuth2Persister;
import org.apache.shindig.gadgets.oauth2.persistence.OAuth2TokenPersistence;

public class BasicOAuth2Store
implements OAuth2Store {
    private static final String LOG_CLASS = BasicOAuth2Store.class.getName();
    private static final FilteredLogger LOG = FilteredLogger.getFilteredLogger(LOG_CLASS);
    private final OAuth2Cache cache;
    private final String globalRedirectUri;
    private final Authority authority;
    private final String contextRoot;
    private final OAuth2Persister persister;
    private final OAuth2Encrypter encrypter;
    private final BlobCrypter stateCrypter;

    @Inject
    public BasicOAuth2Store(OAuth2Cache cache, OAuth2Persister persister, OAuth2Encrypter encrypter, String globalRedirectUri, Authority authority, String contextRoot, @Named(value="shindig.oauth2.state-crypter") BlobCrypter stateCrypter) {
        this.cache = cache;
        this.persister = persister;
        this.globalRedirectUri = globalRedirectUri;
        this.authority = authority;
        this.contextRoot = contextRoot;
        this.encrypter = encrypter;
        this.stateCrypter = stateCrypter;
        if (LOG.isLoggable()) {
            LOG.log("this.cache = {0}", this.cache);
            LOG.log("this.persister = {0}", this.persister);
            LOG.log("this.globalRedirectUri = {0}", this.globalRedirectUri);
            LOG.log("this.encrypter = {0}", this.encrypter);
            LOG.log("this.stateCrypter = {0}", this.stateCrypter);
        }
    }

    @Override
    public boolean clearCache() throws GadgetException {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "clearCache");
        }
        try {
            this.cache.clearClients();
            this.cache.clearTokens();
            this.cache.clearAccessors();
        }
        catch (OAuth2PersistenceException e) {
            if (isLogging) {
                LOG.log("Error clearing OAuth2 cache", e);
            }
            throw new GadgetException(GadgetException.Code.OAUTH_STORAGE_ERROR, "Error clearing OAuth2 cache", e);
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "clearCache", true);
        }
        return true;
    }

    @Override
    public OAuth2Token createToken() {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "createToken");
        }
        OAuth2Token ret = this.internalCreateToken();
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "clearCache", ret);
        }
        return ret;
    }

    public OAuth2Client getClient(String gadgetUri, String serviceName) throws GadgetException {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "getClient", new Object[]{gadgetUri, serviceName});
        }
        OAuth2Client client = this.cache.getClient(gadgetUri, serviceName);
        if (isLogging) {
            LOG.log("client from cache = {0}", client);
        }
        if (client == null) {
            try {
                client = this.persister.findClient(gadgetUri, serviceName);
                if (client != null) {
                    this.cache.storeClient(client);
                }
            }
            catch (OAuth2PersistenceException e) {
                if (isLogging) {
                    LOG.log("Error loading OAuth2 client ", e);
                }
                throw new GadgetException(GadgetException.Code.OAUTH_STORAGE_ERROR, "Error loading OAuth2 client " + serviceName, e);
            }
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "getClient", client);
        }
        return client;
    }

    @Override
    public OAuth2Accessor getOAuth2Accessor(OAuth2CallbackState state) {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "getOAuth2Accessor", state);
        }
        OAuth2Accessor ret = this.cache.getOAuth2Accessor(state);
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "getOAuth2Accessor", ret);
        }
        return ret;
    }

    @Override
    public OAuth2Accessor getOAuth2Accessor(String gadgetUri, String serviceName, String user, String scope) throws GadgetException {
        OAuth2Client client;
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "getOAuth2Accessor", new Object[]{gadgetUri, serviceName, user, scope});
        }
        OAuth2CallbackState state = new OAuth2CallbackState(this.stateCrypter);
        state.setGadgetUri(gadgetUri);
        state.setServiceName(serviceName);
        state.setUser(user);
        state.setScope(scope);
        OAuth2Accessor ret = this.cache.getOAuth2Accessor(state);
        if (!(ret != null && ret.isValid() || (client = this.getClient(gadgetUri, serviceName)) == null)) {
            OAuth2Token accessToken = this.getToken(gadgetUri, serviceName, user, scope, OAuth2Token.Type.ACCESS);
            OAuth2Token refreshToken = this.getToken(gadgetUri, serviceName, user, scope, OAuth2Token.Type.REFRESH);
            BasicOAuth2Accessor newAccessor = new BasicOAuth2Accessor(gadgetUri, serviceName, user, scope, client.isAllowModuleOverride(), this, this.globalRedirectUri, this.authority, this.contextRoot);
            newAccessor.setAccessToken(accessToken);
            newAccessor.setAuthorizationUrl(client.getAuthorizationUrl());
            newAccessor.setClientAuthenticationType(client.getClientAuthenticationType());
            newAccessor.setAuthorizationHeader(client.isAuthorizationHeader());
            newAccessor.setUrlParameter(client.isUrlParameter());
            newAccessor.setClientId(client.getClientId());
            newAccessor.setClientSecret(client.getClientSecret());
            newAccessor.setGrantType(client.getGrantType());
            newAccessor.setRedirectUri(client.getRedirectUri());
            newAccessor.setRefreshToken(refreshToken);
            newAccessor.setTokenUrl(client.getTokenUrl());
            newAccessor.setType(client.getType());
            newAccessor.setAllowedDomains(client.getAllowedDomains());
            ret = newAccessor;
            this.storeOAuth2Accessor(ret);
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "getOAuth2Accessor", ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OAuth2Token getToken(String gadgetUri, String serviceName, String user, String scope, OAuth2Token.Type type) throws GadgetException {
        OAuth2Token token;
        boolean isLogging;
        block11: {
            String processedGadgetUri;
            isLogging = LOG.isLoggable();
            if (isLogging) {
                LOG.entering(LOG_CLASS, "getToken", new Object[]{gadgetUri, serviceName, user, scope, type});
            }
            if ((token = this.cache.getToken(processedGadgetUri = this.getGadgetUri(gadgetUri, serviceName), serviceName, user, scope, type)) == null) {
                try {
                    token = this.persister.findToken(processedGadgetUri, serviceName, user, scope, type);
                    if (token == null) break block11;
                    OAuth2Token oAuth2Token = token;
                    synchronized (oAuth2Token) {
                        try {
                            token.setGadgetUri(processedGadgetUri);
                            this.cache.storeToken(token);
                        }
                        finally {
                            token.setGadgetUri(gadgetUri);
                        }
                    }
                }
                catch (OAuth2PersistenceException e) {
                    throw new GadgetException(GadgetException.Code.OAUTH_STORAGE_ERROR, "Error loading OAuth2 token", e);
                }
            }
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "getToken", token);
        }
        return token;
    }

    @Override
    public boolean init() throws GadgetException {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "init");
        }
        if (this.cache.isPrimed()) {
            if (isLogging) {
                LOG.exiting(LOG_CLASS, "init", false);
            }
            return false;
        }
        this.clearCache();
        try {
            Set<OAuth2Client> clients = this.persister.loadClients();
            if (isLogging) {
                LOG.log("clients = {0}", clients);
            }
            this.cache.storeClients(clients);
        }
        catch (OAuth2PersistenceException e) {
            throw new GadgetException(GadgetException.Code.OAUTH_STORAGE_ERROR, "Error loading OAuth2 clients", e);
        }
        try {
            Set<OAuth2Token> tokens = this.persister.loadTokens();
            if (isLogging) {
                LOG.log("tokens = {0}", tokens);
            }
            this.cache.storeTokens(tokens);
        }
        catch (OAuth2PersistenceException e) {
            throw new GadgetException(GadgetException.Code.OAUTH_STORAGE_ERROR, "Error loading OAuth2 tokens", e);
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "init", true);
        }
        return true;
    }

    @Override
    public OAuth2Accessor removeOAuth2Accessor(OAuth2Accessor accessor) {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "removeOAuth2Accessor", accessor);
        }
        OAuth2Accessor ret = null;
        if (accessor != null) {
            return this.cache.removeOAuth2Accessor(accessor);
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "removeOAuth2Accessor", ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OAuth2Token removeToken(OAuth2Token token) throws GadgetException {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "removeToken", token);
        }
        if (token != null) {
            if (isLogging) {
                LOG.exiting(LOG_CLASS, "removeToken", token);
            }
            try {
                OAuth2Token oAuth2Token = token;
                synchronized (oAuth2Token) {
                    String origGadgetApi = token.getGadgetUri();
                    String processedGadgetUri = this.getGadgetUri(token.getGadgetUri(), token.getServiceName());
                    token.setGadgetUri(processedGadgetUri);
                    try {
                        this.cache.removeToken(token);
                        this.persister.removeToken(processedGadgetUri, token.getServiceName(), token.getUser(), token.getScope(), token.getType());
                    }
                    finally {
                        token.setGadgetUri(origGadgetApi);
                    }
                }
                return token;
            }
            catch (OAuth2PersistenceException e) {
                if (isLogging) {
                    LOG.log("Error removing OAuth2 token ", e);
                }
                throw new GadgetException(GadgetException.Code.OAUTH_STORAGE_ERROR, "Error removing OAuth2 token " + token.getServiceName(), e);
            }
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "removeToken", null);
        }
        return null;
    }

    public static boolean runImport(OAuth2Persister source, OAuth2Persister target, boolean clean) {
        if (LOG.isLoggable()) {
            LOG.entering(LOG_CLASS, "runImport", new Object[]{source, target, clean});
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setToken(OAuth2Token token) throws GadgetException {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "setToken", token);
        }
        if (token != null) {
            String gadgetUri = token.getGadgetUri();
            String serviceName = token.getServiceName();
            String processedGadgetUri = this.getGadgetUri(gadgetUri, serviceName);
            OAuth2Token oAuth2Token = token;
            synchronized (oAuth2Token) {
                token.setGadgetUri(processedGadgetUri);
                try {
                    OAuth2Token existingToken = this.getToken(gadgetUri, token.getServiceName(), token.getUser(), token.getScope(), token.getType());
                    try {
                        if (existingToken == null) {
                            this.persister.insertToken(token);
                        } else {
                            OAuth2Token oAuth2Token2 = existingToken;
                            synchronized (oAuth2Token2) {
                                try {
                                    existingToken.setGadgetUri(processedGadgetUri);
                                    this.cache.removeToken(existingToken);
                                    this.persister.updateToken(token);
                                }
                                finally {
                                    existingToken.setGadgetUri(gadgetUri);
                                }
                            }
                        }
                        this.cache.storeToken(token);
                    }
                    catch (OAuth2CacheException e) {
                        if (isLogging) {
                            LOG.log("Error storing OAuth2 token", e);
                        }
                        throw new GadgetException(GadgetException.Code.OAUTH_STORAGE_ERROR, "Error storing OAuth2 token", e);
                    }
                    catch (OAuth2PersistenceException e) {
                        if (isLogging) {
                            LOG.log("Error storing OAuth2 token", e);
                        }
                        throw new GadgetException(GadgetException.Code.OAUTH_STORAGE_ERROR, "Error storing OAuth2 token", e);
                    }
                }
                finally {
                    token.setGadgetUri(gadgetUri);
                }
            }
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "setToken");
        }
    }

    @Override
    public void storeOAuth2Accessor(OAuth2Accessor accessor) {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "storeOAuth2Accessor", accessor);
        }
        this.cache.storeOAuth2Accessor(accessor);
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "storeOAuth2Accessor");
        }
    }

    protected String getGadgetUri(String gadgetUri, String serviceName) throws GadgetException {
        String ret = gadgetUri;
        OAuth2Client client = this.getClient(ret, serviceName);
        if (client != null && client.isSharedToken()) {
            ret = client.getClientId() + ':' + client.getServiceName();
        }
        return ret;
    }

    protected OAuth2Token internalCreateToken() {
        return new OAuth2TokenPersistence(this.encrypter);
    }

    @Override
    public BlobCrypter getStateCrypter() {
        return this.stateCrypter;
    }

    @Override
    public OAuth2Client invalidateClient(OAuth2Client client) {
        return this.cache.removeClient(client);
    }

    @Override
    public OAuth2Token invalidateToken(OAuth2Token token) {
        return this.cache.removeToken(token);
    }

    @Override
    public void clearAccessorCache() throws GadgetException {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "clearAccessorCache");
        }
        try {
            this.cache.clearAccessors();
        }
        catch (OAuth2CacheException e) {
            if (isLogging) {
                LOG.log("Error clearing OAuth2 Accessor cache", e);
            }
            throw new GadgetException(GadgetException.Code.OAUTH_STORAGE_ERROR, "Error clearing OAuth2Accessor cache", e);
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "clearAccessorCache");
        }
    }

    @Override
    public void clearTokenCache() throws GadgetException {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "clearTokenCache");
        }
        try {
            this.cache.clearTokens();
        }
        catch (OAuth2CacheException e) {
            if (isLogging) {
                LOG.log("Error clearing OAuth2 Token cache", e);
            }
            throw new GadgetException(GadgetException.Code.OAUTH_STORAGE_ERROR, "Error clearing OAuth2Token cache", e);
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "clearTokenCache");
        }
    }

    @Override
    public void clearClientCache() throws GadgetException {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "clearClientCache");
        }
        try {
            this.cache.clearClients();
        }
        catch (OAuth2CacheException e) {
            if (isLogging) {
                LOG.log("Error clearing OAuth2 Client cache", e);
            }
            throw new GadgetException(GadgetException.Code.OAUTH_STORAGE_ERROR, "Error clearing OAuth2Client cache", e);
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "clearClientCache");
        }
    }
}

