/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2.handler;

import com.google.common.collect.Maps;
import java.util.HashMap;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.oauth2.OAuth2Accessor;
import org.apache.shindig.gadgets.oauth2.OAuth2Error;
import org.apache.shindig.gadgets.oauth2.OAuth2Token;
import org.apache.shindig.gadgets.oauth2.OAuth2Utils;
import org.apache.shindig.gadgets.oauth2.handler.OAuth2HandlerError;
import org.apache.shindig.gadgets.oauth2.handler.ResourceRequestHandler;

public class BearerTokenHandler
implements ResourceRequestHandler {
    public static final String TOKEN_TYPE = "Bearer";
    private static final OAuth2Error ERROR = OAuth2Error.BEARER_TOKEN_PROBLEM;

    @Override
    public OAuth2HandlerError addOAuth2Params(OAuth2Accessor accessor, HttpRequest request) {
        try {
            if (accessor == null || !accessor.isValid() || accessor.isErrorResponse()) {
                return BearerTokenHandler.getError("accessor is invalid " + accessor);
            }
            if (request == null) {
                return BearerTokenHandler.getError("request is null");
            }
            Uri unAuthorizedRequestUri = request.getUri();
            if (unAuthorizedRequestUri == null) {
                return BearerTokenHandler.getError("unAuthorizedRequestUri is null");
            }
            OAuth2Token accessToken = accessor.getAccessToken();
            if (accessToken == null || accessToken.getTokenType().length() == 0) {
                return BearerTokenHandler.getError("accessToken is invalid " + accessToken);
            }
            if (!TOKEN_TYPE.equalsIgnoreCase(accessToken.getTokenType())) {
                return BearerTokenHandler.getError("token type mismatch expected Bearer but got " + accessToken.getTokenType());
            }
            if (accessor.isUrlParameter()) {
                HashMap queryParams = Maps.newHashMap();
                byte[] secretBytes = accessToken.getSecret();
                String secret = new String(secretBytes, "UTF-8");
                queryParams.put("access_token", secret);
                String authorizedUriString = OAuth2Utils.buildUrl(unAuthorizedRequestUri.toString(), queryParams, null);
                request.setUri(Uri.parse((String)authorizedUriString));
            }
            if (accessor.isAuthorizationHeader()) {
                request.setHeader("Authorization", "Bearer " + new String(accessToken.getSecret(), "UTF-8"));
            }
            return null;
        }
        catch (Exception e) {
            return BearerTokenHandler.getError("Exception occurred " + e.getMessage(), e);
        }
    }

    @Override
    public String getTokenType() {
        return TOKEN_TYPE;
    }

    private static OAuth2HandlerError getError(String contextMessage) {
        return BearerTokenHandler.getError(contextMessage, null);
    }

    private static OAuth2HandlerError getError(String contextMessage, Exception e) {
        return new OAuth2HandlerError(ERROR, contextMessage, e, "", "");
    }
}

