/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.preload;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.shindig.gadgets.FetchResponseUtils;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.oauth2.OAuth2Arguments;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.preload.Preloader;
import org.apache.shindig.gadgets.spec.Preload;
import org.apache.shindig.gadgets.spec.RequestAuthenticationInfo;

public class HttpPreloader
implements Preloader {
    private final RequestPipeline requestPipeline;

    @Inject
    public HttpPreloader(RequestPipeline requestPipeline) {
        this.requestPipeline = requestPipeline;
    }

    @Override
    public Collection<Callable<PreloadedData>> createPreloadTasks(Gadget gadget) {
        ArrayList preloads = Lists.newArrayList();
        GadgetContext context = gadget.getContext();
        for (Preload preload : gadget.getSpec().getModulePrefs().getPreloads()) {
            Set<String> preloadViews = preload.getViews();
            if (!preloadViews.isEmpty() && !preloadViews.contains(context.getView())) continue;
            preloads.add(new PreloadTask(context, preload, preload.getHref().toString()));
        }
        return preloads;
    }

    public static HttpRequest newHttpRequest(GadgetContext context, RequestAuthenticationInfo authenticationInfo) throws GadgetException {
        return new HttpRequest(authenticationInfo.getHref()).setSecurityToken(context.getToken()).setOAuthArguments(new OAuthArguments(authenticationInfo)).setOAuth2Arguments(new OAuth2Arguments(authenticationInfo)).setAuthType(authenticationInfo.getAuthType()).setContainer(context.getContainer()).setGadget(context.getUrl()).setIgnoreCache(context.getIgnoreCache());
    }

    private static class HttpPreloadData
    implements PreloadedData {
        private final Map<String, Object> data;

        public HttpPreloadData(HttpResponse response, String key) {
            this.data = FetchResponseUtils.getResponseAsJson(response, key, response.getResponseAsString(), false);
        }

        @Override
        public Collection<Object> toJson() {
            return ImmutableList.of(this.data);
        }
    }

    class PreloadTask
    implements Callable<PreloadedData> {
        private final GadgetContext context;
        private final Preload preload;
        private final String key;

        public PreloadTask(GadgetContext context, Preload preload, String key) {
            this.context = context;
            this.preload = preload;
            this.key = key;
        }

        @Override
        public PreloadedData call() throws Exception {
            HttpRequest request = HttpPreloader.newHttpRequest(this.context, this.preload);
            return new HttpPreloadData(HttpPreloader.this.requestPipeline.execute(request), this.key);
        }
    }
}

