/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.lexer.TokenStream;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.js.Parser;
import com.google.caja.plugin.LoaderType;
import com.google.caja.plugin.PipelineMaker;
import com.google.caja.plugin.PluginCompiler;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.UriEffect;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.UriPolicy;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsMinimalPrinter;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.RenderContext;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.ResponseRewriter;
import org.apache.shindig.gadgets.rewrite.RewriterUtils;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.uri.ProxyUriManager;

public class CajaResponseRewriter
implements ResponseRewriter {
    private static final String classname = CajaResponseRewriter.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");
    private final RequestPipeline requestPipeline;

    @Inject
    public CajaResponseRewriter(RequestPipeline requestPipeline) {
        this.requestPipeline = requestPipeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rewrite(HttpRequest req, HttpResponseBuilder resp, Gadget gadget) throws RewritingException {
        if (!req.isCajaRequested()) {
            return;
        }
        if (!RewriterUtils.isJavascript(req, resp)) {
            resp.setContent("");
            resp.setHttpStatusCode(400);
            return;
        }
        boolean passed = false;
        SimpleMessageQueue mq = new SimpleMessageQueue();
        MessageContext mc = new MessageContext();
        Uri contextUri = req.getUri();
        InputSource is = new InputSource(contextUri.toJavaUri());
        PluginMeta pluginMeta = new PluginMeta(this.proxyFetcher(req, contextUri), this.proxyUriPolicy(req));
        PluginCompiler compiler = new PluginCompiler(BuildInfo.getInstance(), pluginMeta, (MessageQueue)mq);
        compiler.setMessageContext(mc);
        try {
            StringReader strReader = new StringReader(resp.getContent());
            CharProducer cp = CharProducer.Factory.create((StringReader)strReader, (InputSource)is);
            JsTokenQueue tq = new JsTokenQueue((TokenStream)new JsLexer(cp), is);
            Block input = new Parser(tq, (MessageQueue)mq).parse();
            tq.expectEmpty();
            compiler.addInput(AncestorChain.instance((ParseTreeNode)input).node, contextUri.toJavaUri());
        }
        catch (ParseException e) {
            resp.setContent("");
            return;
        }
        try {
            if (RewriterUtils.isJavascript(req, resp)) {
                compiler.setGoals(compiler.getGoals().without(PipelineMaker.HTML_SAFE_STATIC));
            }
            CajoledModule outputJs = (passed = compiler.run()) ? compiler.getJavascript() : null;
            StringBuilder jsOut = new StringBuilder();
            Object printer = "1".equals(req.getParam("debug")) ? new JsPrettyPrinter(new Concatenator(jsOut)) : new JsMinimalPrinter(new Concatenator(jsOut));
            RenderContext renderContext = new RenderContext((TokenConsumer)printer).withEmbeddable(true);
            if (outputJs != null) {
                outputJs.render(renderContext);
            }
            renderContext.getOut().noMoreTokens();
            resp.setContent(jsOut.toString());
        }
        finally {
            if (!passed) {
                resp.setContent("");
            }
        }
    }

    private UriPolicy proxyUriPolicy(HttpRequest request) {
        final Uri contextUri = request.getUri();
        final Gadget stubGadget = DomWalker.makeGadget(request);
        return new UriPolicy(){

            public String rewriteUri(ExternalReference ref, UriEffect effect, LoaderType loader, Map<String, ?> hints) {
                Uri resourceUri = Uri.fromJavaUri((URI)ref.getUri());
                if (contextUri != null) {
                    resourceUri = contextUri.resolve(resourceUri);
                }
                ProxyUriManager.ProxyUri proxyUri = new ProxyUriManager.ProxyUri(stubGadget, resourceUri);
                return proxyUri.getResource().toString();
            }
        };
    }

    private UriFetcher proxyFetcher(final HttpRequest req, final Uri contextUri) {
        return new UriFetcher(){

            public FetchedData fetch(ExternalReference ref, String mimeType) throws UriFetcher.UriFetchException {
                Uri resourceUri = Uri.fromJavaUri((URI)ref.getUri());
                if (contextUri != null) {
                    resourceUri = contextUri.resolve(resourceUri);
                }
                HttpRequest request = new HttpRequest(resourceUri).setContainer(req.getContainer()).setGadget(req.getGadget()).setInternalRequest(true);
                try {
                    HttpResponse response = CajaResponseRewriter.this.requestPipeline.execute(request);
                    byte[] responseBytes = IOUtils.toByteArray((InputStream)response.getResponse());
                    return FetchedData.fromBytes((byte[])responseBytes, (String)mimeType, (String)response.getEncoding(), (InputSource)new InputSource(ref.getUri()));
                }
                catch (GadgetException e) {
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.logp(Level.INFO, classname, "proxyFetcher", "failedToRetrieve", new Object[]{ref.toString()});
                    }
                    return null;
                }
                catch (IOException e) {
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.logp(Level.INFO, classname, "proxyFetcher", "failedToRead", new Object[]{ref.toString()});
                    }
                    return null;
                }
            }
        };
    }
}

