/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.common.Pair;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpCache;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.ResourceMutateVisitor;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CacheEnforcementVisitor
extends ResourceMutateVisitor {
    private static final Logger logger = Logger.getLogger(CacheEnforcementVisitor.class.getName());
    public static final String CACHE_ENFORCEMENT_FETCH_PARAM = "X-shindig-cache-enforcement-fetch";
    private final HttpCache cache;
    private final RequestPipeline requestPipeline;
    private final Executor executor;

    public CacheEnforcementVisitor(ContentRewriterFeature.Config featureConfig, Executor executor, HttpCache cache, RequestPipeline requestPipeline, ResourceMutateVisitor.Tags ... resourceTags) {
        super(featureConfig, resourceTags);
        this.executor = executor;
        this.cache = cache;
        this.requestPipeline = requestPipeline;
    }

    protected HttpRequest createNewHttpRequest(Gadget gadget, String uriStr) {
        HttpRequest request = new HttpRequest(Uri.parse((String)uriStr));
        if (gadget != null) {
            GadgetContext context;
            GadgetSpec spec = gadget.getSpec();
            if (spec != null) {
                request.setGadget(spec.getUrl());
            }
            if ((context = gadget.getContext()) != null) {
                request.setContainer(context.getContainer());
            }
            request.setParam(CACHE_ENFORCEMENT_FETCH_PARAM, "1");
        }
        return request;
    }

    @Override
    public DomWalker.Visitor.VisitStatus visit(Gadget gadget, Node node) throws RewritingException {
        if (super.visit(gadget, node).equals((Object)DomWalker.Visitor.VisitStatus.RESERVE_NODE)) {
            Element element = (Element)node;
            String nodeName = node.getNodeName().toLowerCase();
            String uriStr = element.getAttribute((String)this.resourceTags.get(nodeName)).trim();
            HttpRequest request = this.createNewHttpRequest(gadget, uriStr);
            HttpResponse response = this.cache.getResponse(request);
            if (response == null) {
                return this.handleResponseNotInCache(request);
            }
            return this.handleResponseInCache(request, response);
        }
        return DomWalker.Visitor.VisitStatus.BYPASS;
    }

    protected DomWalker.Visitor.VisitStatus handleResponseInCache(HttpRequest request, HttpResponse response) {
        if (response.shouldRefetch()) {
            if (response.getCacheControlMaxAge() != 0L) {
                this.triggerFetch(request);
            }
            return DomWalker.Visitor.VisitStatus.RESERVE_NODE;
        }
        if (response.isStrictNoCache() || response.getHeader("Set-Cookie") != null || response.isError()) {
            return DomWalker.Visitor.VisitStatus.RESERVE_NODE;
        }
        return DomWalker.Visitor.VisitStatus.BYPASS;
    }

    protected DomWalker.Visitor.VisitStatus handleResponseNotInCache(HttpRequest request) {
        this.triggerFetch(request);
        return DomWalker.Visitor.VisitStatus.RESERVE_NODE;
    }

    protected void triggerFetch(final HttpRequest request) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    CacheEnforcementVisitor.this.requestPipeline.execute(request);
                }
                catch (GadgetException e) {
                    logger.log(Level.WARNING, "Triggered fetch failed for " + request, e);
                }
            }
        });
    }

    @Override
    protected Collection<Pair<Node, Uri>> mutateUris(Gadget gadget, Collection<Node> nodes) {
        return ImmutableList.of();
    }
}

