/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.caja.lexer.ParseException;
import com.google.caja.parser.AbstractParseTreeNode;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.css.CssTree;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.parse.caja.CajaCssParser;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.ResponseRewriter;
import org.apache.shindig.gadgets.rewrite.RewriterUtils;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.w3c.dom.Element;

public class CssResponseRewriter
implements ResponseRewriter {
    private static final String classname = CssResponseRewriter.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");
    private final CajaCssParser cssParser;
    protected final ProxyUriManager proxyUriManager;
    protected final ContentRewriterFeature.Factory rewriterFeatureFactory;

    @Inject
    public CssResponseRewriter(CajaCssParser cssParser, ProxyUriManager proxyUriManager, ContentRewriterFeature.Factory rewriterFeatureFactory) {
        this.cssParser = cssParser;
        this.proxyUriManager = proxyUriManager;
        this.rewriterFeatureFactory = rewriterFeatureFactory;
    }

    @Override
    public void rewrite(HttpRequest request, HttpResponseBuilder original, Gadget gadget) throws RewritingException {
        ContentRewriterFeature.Config config = this.rewriterFeatureFactory.get(request);
        if (!RewriterUtils.isCss(request, original)) {
            return;
        }
        String css = original.getContent();
        StringWriter sw = new StringWriter(css.length() * 110 / 100);
        this.rewrite(new StringReader(css), request.getUri(), new UriMaker(this.proxyUriManager, config), sw, false, DomWalker.makeGadget(request).getContext());
        original.setContent(sw.toString());
    }

    public List<String> rewrite(Reader content, Uri source, UriMaker uriMaker, Writer writer, boolean extractImports, GadgetContext gadgetContext) throws RewritingException {
        try {
            String original = IOUtils.toString((Reader)content);
            try {
                CssTree.StyleSheet stylesheet = this.cssParser.parseDom(original, source);
                List<String> stringList = CssResponseRewriter.rewrite(stylesheet, source, uriMaker, extractImports, gadgetContext);
                this.cssParser.serialize(stylesheet, writer);
                return stringList;
            }
            catch (GadgetException ge) {
                if (ge.getCause() instanceof ParseException) {
                    if (LOG.isLoggable(Level.WARNING)) {
                        LOG.logp(Level.WARNING, classname, "rewrite", "cajaCssParseFailure", new Object[]{ge.getCause().getMessage(), source});
                    }
                    writer.write(original);
                    return Collections.emptyList();
                }
                throw new RewritingException(ge, ge.getHttpStatusCode());
            }
        }
        catch (IOException ioe) {
            throw new RewritingException(ioe, 500);
        }
    }

    public List<String> rewrite(Element styleNode, Uri source, UriMaker uriMaker, boolean extractImports, GadgetContext gadgetContext) throws RewritingException {
        try {
            CssTree.StyleSheet stylesheet = this.cssParser.parseDom(styleNode.getTextContent(), source);
            List<String> imports = CssResponseRewriter.rewrite(stylesheet, source, uriMaker, extractImports, gadgetContext);
            String content = this.cssParser.serialize(stylesheet);
            if (Strings.isNullOrEmpty((String)content) || StringUtils.isWhitespace((CharSequence)content)) {
                styleNode.getParentNode().removeChild(styleNode);
            } else {
                styleNode.setTextContent(content);
            }
            return imports;
        }
        catch (GadgetException ge) {
            if (ge.getCause() instanceof ParseException) {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.logp(Level.WARNING, classname, "rewrite", "cajaCssParseFailure", new Object[]{ge.getCause().getMessage(), source});
                }
                return Collections.emptyList();
            }
            throw new RewritingException(ge, ge.getHttpStatusCode());
        }
    }

    public static List<String> rewrite(CssTree.StyleSheet styleSheet, final Uri source, final UriMaker uriMaker, final boolean extractImports, final GadgetContext gadgetContext) {
        final LinkedList imports = Lists.newLinkedList();
        final LinkedList skip = Lists.newLinkedList();
        styleSheet.acceptPreOrder(new Visitor(){

            public boolean visit(AncestorChain<?> chain) {
                if (chain.node instanceof CssTree.Import) {
                    CssTree.Import importNode = (CssTree.Import)chain.node;
                    CssTree.UriLiteral uriLiteral = importNode.getUri();
                    skip.add(importNode.getUri());
                    if (extractImports) {
                        imports.add(uriLiteral.getValue());
                        ((AbstractParseTreeNode)chain.getParentNode()).removeChild(chain.node);
                    } else {
                        String rewritten = CssResponseRewriter.rewriteUri(uriMaker, uriLiteral.getValue(), source, gadgetContext);
                        uriLiteral.setValue(rewritten);
                    }
                } else if (chain.node instanceof CssTree.UriLiteral && !skip.contains(chain.node)) {
                    CssTree.UriLiteral uriDecl = (CssTree.UriLiteral)chain.node;
                    String rewritten = CssResponseRewriter.rewriteUri(uriMaker, uriDecl.getValue(), source, gadgetContext);
                    uriDecl.setValue(rewritten);
                }
                return true;
            }
        }, null);
        return imports;
    }

    private static String rewriteUri(UriMaker uriMaker, String input, Uri context, GadgetContext gadgetContext) {
        Uri inboundUri;
        try {
            inboundUri = Uri.parse((String)input);
        }
        catch (IllegalArgumentException e) {
            return input;
        }
        if (context != null) {
            inboundUri = context.resolve(inboundUri);
        }
        ProxyUriManager.ProxyUri proxyUri = new ProxyUriManager.ProxyUri(DomWalker.makeGadget(gadgetContext), inboundUri);
        return uriMaker.make(proxyUri, context).toString();
    }

    public static UriMaker uriMaker(ProxyUriManager wrapped, ContentRewriterFeature.Config config) {
        return new UriMaker(wrapped, config);
    }

    public static class UriMaker {
        protected final ProxyUriManager wrapped;
        protected final ContentRewriterFeature.Config config;

        public UriMaker(ProxyUriManager wrapped, ContentRewriterFeature.Config config) {
            this.wrapped = wrapped;
            this.config = config;
        }

        public Uri make(ProxyUriManager.ProxyUri uri, Uri context) {
            if (this.config.shouldRewriteURL(uri.getResource().toString())) {
                ArrayList puris = Lists.newArrayList((Object[])new ProxyUriManager.ProxyUri[]{uri});
                List<Uri> returned = this.wrapped.make(puris, null);
                return returned.get(0);
            }
            return context.resolve(uri.getResource());
        }
    }
}

