/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import java.util.List;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.DomUtil;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.CssResponseRewriter;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.spec.View;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StyleTagExtractorVisitor
implements DomWalker.Visitor {
    private final ContentRewriterFeature.Config config;
    private final CssResponseRewriter cssRewriter;
    private final ProxyUriManager proxyUriManager;

    public StyleTagExtractorVisitor(ContentRewriterFeature.Config config, CssResponseRewriter cssRewriter, ProxyUriManager proxyUriManager) {
        this.config = config;
        this.cssRewriter = cssRewriter;
        this.proxyUriManager = proxyUriManager;
    }

    @Override
    public DomWalker.Visitor.VisitStatus visit(Gadget gadget, Node node) throws RewritingException {
        if (!this.config.isRewriteEnabled() || !this.config.getIncludedTags().contains("style")) {
            return DomWalker.Visitor.VisitStatus.BYPASS;
        }
        if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase("style")) {
            return DomWalker.Visitor.VisitStatus.BYPASS;
        }
        return DomWalker.Visitor.VisitStatus.RESERVE_NODE;
    }

    @Override
    public boolean revisit(Gadget gadget, List<Node> nodes) throws RewritingException {
        boolean mutated = false;
        if (nodes.isEmpty()) {
            return mutated;
        }
        Uri contentBase = gadget.getSpec().getUrl();
        View view = gadget.getCurrentView();
        if (view != null && view.getHref() != null) {
            contentBase = view.getHref();
        }
        Element head = (Element)DomUtil.getFirstNamedChildNode((Node)nodes.get(0).getOwnerDocument().getDocumentElement(), (String)"head");
        for (Node node : nodes) {
            Element elem = (Element)node;
            List<String> extractedUrls = this.cssRewriter.rewrite(elem, contentBase, CssResponseRewriter.uriMaker(this.proxyUriManager, this.config), true, gadget.getContext());
            for (String extractedUrl : extractedUrls) {
                Element newLink = head.getOwnerDocument().createElement("link");
                newLink.setAttribute("rel", "stylesheet");
                newLink.setAttribute("type", "text/css");
                newLink.setAttribute("href", extractedUrl);
                head.appendChild(newLink);
                mutated = true;
            }
        }
        return mutated;
    }
}

