/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.common.JsonSerializer;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.DomUtil;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.MessageBundleFactory;
import org.apache.shindig.gadgets.parse.SocialDataTags;
import org.apache.shindig.gadgets.render.SanitizingGadgetRewriter;
import org.apache.shindig.gadgets.rewrite.GadgetRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.MessageBundle;
import org.apache.shindig.gadgets.templates.ContainerTagLibraryFactory;
import org.apache.shindig.gadgets.templates.MessageELResolver;
import org.apache.shindig.gadgets.templates.TagRegistry;
import org.apache.shindig.gadgets.templates.TemplateContext;
import org.apache.shindig.gadgets.templates.TemplateLibrary;
import org.apache.shindig.gadgets.templates.TemplateLibraryFactory;
import org.apache.shindig.gadgets.templates.TemplateParserException;
import org.apache.shindig.gadgets.templates.TemplateProcessor;
import org.apache.shindig.gadgets.templates.TemplateResource;
import org.apache.shindig.gadgets.templates.tags.CompositeTagRegistry;
import org.apache.shindig.gadgets.templates.tags.DefaultTagRegistry;
import org.apache.shindig.gadgets.templates.tags.TagHandler;
import org.apache.shindig.gadgets.templates.tags.TemplateBasedTagHandler;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TemplateRewriter
implements GadgetRewriter {
    public static final Set<String> TAGS = ImmutableSet.of((Object)"script");
    public static final String TEMPLATES_FEATURE_NAME = "opensocial-templates";
    public static final String OSML_FEATURE_NAME = "osml";
    public static final String REQUIRE_LIBRARY_PARAM = "requireLibrary";
    static final String DISABLE_AUTO_PROCESSING_PARAM = "disableAutoProcessing";
    static final String CLIENT_SUPPORT_PARAM = "client";
    private static final String classname = TemplateRewriter.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");
    private final Provider<TemplateProcessor> processor;
    private final MessageBundleFactory messageBundleFactory;
    private final Expressions expressions;
    private final TagRegistry baseTagRegistry;
    private final TemplateLibraryFactory libraryFactory;
    private final ContainerTagLibraryFactory containerTagLibraryFactory;

    @Inject
    public TemplateRewriter(Provider<TemplateProcessor> processor, MessageBundleFactory messageBundleFactory, Expressions expressions, TagRegistry baseTagRegistry, TemplateLibraryFactory libraryFactory, ContainerTagLibraryFactory containerTagLibraryFactory) {
        this.processor = processor;
        this.messageBundleFactory = messageBundleFactory;
        this.expressions = expressions;
        this.baseTagRegistry = baseTagRegistry;
        this.libraryFactory = libraryFactory;
        this.containerTagLibraryFactory = containerTagLibraryFactory;
    }

    @Override
    public void rewrite(Gadget gadget, MutableContent content) throws RewritingException {
        Map<String, Feature> directFeatures = gadget.getViewFeatures();
        Feature feature = directFeatures.get(TEMPLATES_FEATURE_NAME);
        if (feature == null && directFeatures.containsKey(OSML_FEATURE_NAME)) {
            feature = directFeatures.get(OSML_FEATURE_NAME);
        }
        if (feature != null && this.isServerTemplatingEnabled(feature)) {
            try {
                this.rewriteImpl(gadget, feature, content);
            }
            catch (GadgetException ge) {
                throw new RewritingException(ge, ge.getHttpStatusCode());
            }
        }
    }

    private boolean isServerTemplatingEnabled(Feature feature) {
        return !"true".equalsIgnoreCase(feature.getParam(DISABLE_AUTO_PROCESSING_PARAM));
    }

    private void rewriteImpl(Gadget gadget, Feature feature, MutableContent content) throws GadgetException {
        ArrayList registries = Lists.newArrayList();
        ArrayList libraries = Lists.newArrayList();
        registries.add(this.baseTagRegistry);
        TemplateLibrary osmlLibrary = this.containerTagLibraryFactory.getLibrary(gadget.getContext().getContainer());
        registries.add(osmlLibrary.getTagRegistry());
        libraries.add(osmlLibrary);
        List<Element> templateElements = SocialDataTags.getTags(content.getDocument(), "ostemplate");
        ImmutableList templates = ImmutableList.copyOf(templateElements);
        if (!OSML_FEATURE_NAME.equals(feature.getName())) {
            registries.add(this.registerCustomTags((List<Element>)templates));
            this.loadTemplateLibraries(gadget.getContext(), feature, registries, libraries);
        }
        CompositeTagRegistry registry = new CompositeTagRegistry(registries);
        TemplateContext templateContext = new TemplateContext(gadget, content.getPipelinedData());
        boolean needsFeature = this.executeTemplates(templateContext, content, (List<Element>)templates, registry);
        String clientOverride = feature.getParam(CLIENT_SUPPORT_PARAM);
        if ("true".equalsIgnoreCase(clientOverride)) {
            needsFeature = true;
        } else if ("false".equalsIgnoreCase(clientOverride)) {
            needsFeature = false;
        }
        Element head = (Element)DomUtil.getFirstNamedChildNode((Node)content.getDocument().getDocumentElement(), (String)"head");
        this.postProcess(templateContext, needsFeature, head, (List<Element>)templates, libraries);
    }

    private void postProcess(TemplateContext templateContext, boolean needsFeature, Element head, List<Element> allTemplates, List<TemplateLibrary> libraries) {
        for (TemplateResource resource : templateContext.getResources()) {
            this.injectTemplateLibraryAssets(resource, head);
        }
        if (!needsFeature) {
            templateContext.getGadget().removeFeature(TEMPLATES_FEATURE_NAME);
            for (Element template : allTemplates) {
                Node parent = template.getParentNode();
                if (parent == null) continue;
                parent.removeChild(template);
            }
        } else {
            for (TemplateLibrary library : libraries) {
                this.injectTemplateLibrary(library, head);
            }
        }
    }

    private void loadTemplateLibraries(GadgetContext context, Feature feature, List<TagRegistry> registries, List<TemplateLibrary> libraries) throws GadgetException {
        Collection urls = feature.getParams().get((Object)REQUIRE_LIBRARY_PARAM);
        if (urls != null) {
            for (String url : urls) {
                Uri uri = Uri.parse((String)url.trim());
                uri = context.getUrl().resolve(uri);
                try {
                    TemplateLibrary library = this.libraryFactory.loadTemplateLibrary(context, uri);
                    registries.add(library.getTagRegistry());
                    libraries.add(library);
                }
                catch (TemplateParserException te) {
                    if (!LOG.isLoggable(Level.WARNING)) continue;
                    LOG.logp(Level.WARNING, classname, "loadTemplateLibraries", "malformedTemplateLib");
                    LOG.log(Level.WARNING, te.getMessage(), te);
                }
            }
        }
    }

    private void injectTemplateLibraryAssets(TemplateResource resource, Element head) {
        Element contentElement;
        switch (resource.getType()) {
            case JAVASCRIPT: {
                contentElement = head.getOwnerDocument().createElement("script");
                contentElement.setAttribute("type", "text/javascript");
                break;
            }
            case STYLE: {
                contentElement = head.getOwnerDocument().createElement("style");
                contentElement.setAttribute("type", "text/css");
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled type");
            }
        }
        if (resource.isSafe()) {
            SanitizingGadgetRewriter.bypassSanitization(contentElement, false);
        }
        contentElement.setTextContent(resource.getContent());
        head.appendChild(contentElement);
    }

    private void injectTemplateLibrary(TemplateLibrary library, Element head) {
        try {
            String libraryContent = library.serialize();
            if (Strings.isNullOrEmpty((String)libraryContent)) {
                return;
            }
            Element scriptElement = head.getOwnerDocument().createElement("script");
            scriptElement.setAttribute("type", "text/javascript");
            StringBuilder buffer = new StringBuilder();
            buffer.append("opensocial.template.Loader.loadContent(");
            JsonSerializer.appendString((Appendable)buffer, (CharSequence)library.serialize());
            buffer.append(',');
            JsonSerializer.appendString((Appendable)buffer, (CharSequence)library.getLibraryUri().toString());
            buffer.append(");");
            scriptElement.setTextContent(buffer.toString());
            head.appendChild(scriptElement);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private TagRegistry registerCustomTags(List<Element> allTemplates) {
        ImmutableSet.Builder handlers = ImmutableSet.builder();
        for (Element template : allTemplates) {
            String namespaceUri;
            Iterable nameParts;
            if (template.getAttribute("tag").length() == 0 || Iterables.size((Iterable)(nameParts = Splitter.on((char)':').split((CharSequence)template.getAttribute("tag")))) != 2 || (namespaceUri = template.lookupNamespaceURI((String)Iterables.get((Iterable)nameParts, (int)0))) == null) continue;
            handlers.add((Object)new TemplateBasedTagHandler(template, namespaceUri, (String)Iterables.get((Iterable)nameParts, (int)1)));
        }
        return new DefaultTagRegistry((Set<TagHandler>)handlers.build());
    }

    private boolean executeTemplates(TemplateContext templateContext, MutableContent content, List<Element> allTemplates, TagRegistry registry) throws GadgetException {
        Map<String, Object> pipelinedData = content.getPipelinedData();
        boolean needsFeature = false;
        ArrayList templates = Lists.newArrayList();
        for (Element element : allTemplates) {
            String tag = element.getAttribute("tag");
            String require = element.getAttribute("require");
            if (!TemplateRewriter.checkRequiredData(require, pipelinedData.keySet())) {
                needsFeature = true;
                continue;
            }
            if (!"".equals(tag)) continue;
            templates.add(element);
        }
        if (!templates.isEmpty()) {
            Gadget gadget = templateContext.getGadget();
            MessageBundle bundle = this.messageBundleFactory.getBundle(gadget.getSpec(), gadget.getContext().getLocale(), gadget.getContext().getIgnoreCache(), gadget.getContext().getContainer(), gadget.getContext().getView());
            MessageELResolver messageELResolver = new MessageELResolver(this.expressions, bundle);
            int autoUpdateID = 0;
            for (Element template : templates) {
                DocumentFragment result = ((TemplateProcessor)this.processor.get()).processTemplate(template, templateContext, messageELResolver, registry);
                if ("true".equals(template.getAttribute("autoUpdate"))) {
                    needsFeature = true;
                    Element span = template.getOwnerDocument().createElement("span");
                    String id = "template_auto" + autoUpdateID++;
                    span.setAttribute("id", "_T_" + id);
                    template.setAttribute("name", id);
                    template.getParentNode().insertBefore(span, template);
                    span.appendChild(result);
                    continue;
                }
                template.getParentNode().insertBefore(result, template);
                template.getParentNode().removeChild(template);
            }
            MutableContent.notifyEdit(content.getDocument());
        }
        return needsFeature;
    }

    private static boolean checkRequiredData(String requiredData, Set<String> availableData) {
        if ("".equals(requiredData)) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(requiredData, ",");
        while (st.hasMoreTokens()) {
            if (availableData.contains(st.nextToken().trim())) continue;
            return false;
        }
        return true;
    }
}

