/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.JsonProperty;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.FeedProcessor;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.oauth2.OAuth2Arguments;
import org.apache.shindig.gadgets.process.ProcessingException;
import org.apache.shindig.gadgets.process.Processor;
import org.apache.shindig.gadgets.rewrite.ResponseRewriterList;
import org.apache.shindig.gadgets.rewrite.ResponseRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.RewriterRegistry;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.apache.shindig.protocol.BaseRequestItem;
import org.apache.shindig.protocol.Operation;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.Service;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Service(name="http")
public class HttpRequestHandler {
    static final Set<String> BAD_HEADERS = ImmutableSet.of((Object)"HOST", (Object)"ACCEPT-ENCODING");
    private static final String CLASSNAME = HttpRequestHandler.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASSNAME, "org.apache.shindig.common.logging.i18n.resource");
    private final RequestPipeline requestPipeline;
    private final ResponseRewriterRegistry contentRewriterRegistry;
    private final Provider<FeedProcessor> feedProcessorProvider;
    private final Processor processor;

    @Inject
    public HttpRequestHandler(RequestPipeline requestPipeline, @RewriterRegistry(rewriteFlow=ResponseRewriterList.RewriteFlow.DEFAULT) ResponseRewriterRegistry contentRewriterRegistry, Provider<FeedProcessor> feedProcessorProvider, Processor processor) {
        this.requestPipeline = requestPipeline;
        this.contentRewriterRegistry = contentRewriterRegistry;
        this.feedProcessorProvider = feedProcessorProvider;
        this.processor = processor;
    }

    @Operation(httpMethods={"POST", "GET"}, path="/get")
    public HttpApiResponse get(BaseRequestItem request) {
        HttpApiRequest httpReq = (HttpApiRequest)request.getTypedRequest(HttpApiRequest.class);
        this.assertNoBody(httpReq, "GET");
        return this.execute("GET", httpReq, request);
    }

    @Operation(httpMethods={"POST"}, path="/post")
    public HttpApiResponse post(BaseRequestItem request) {
        HttpApiRequest httpReq = (HttpApiRequest)request.getTypedRequest(HttpApiRequest.class);
        return this.execute("POST", httpReq, request);
    }

    @Operation(httpMethods={"POST"}, path="/put")
    public HttpApiResponse put(BaseRequestItem request) {
        HttpApiRequest httpReq = (HttpApiRequest)request.getTypedRequest(HttpApiRequest.class);
        return this.execute("PUT", httpReq, request);
    }

    @Operation(httpMethods={"POST"}, path="/delete")
    public HttpApiResponse delete(BaseRequestItem request) {
        HttpApiRequest httpReq = (HttpApiRequest)request.getTypedRequest(HttpApiRequest.class);
        this.assertNoBody(httpReq, "DELETE");
        return this.execute("DELETE", httpReq, request);
    }

    @Operation(httpMethods={"POST", "GET"}, path="/head")
    public HttpApiResponse head(BaseRequestItem request) {
        HttpApiRequest httpReq = (HttpApiRequest)request.getTypedRequest(HttpApiRequest.class);
        this.assertNoBody(httpReq, "HEAD");
        return this.execute("HEAD", httpReq, request);
    }

    private void assertNoBody(HttpApiRequest httpRequest, String method) {
        if (httpRequest.body != null) {
            throw new ProtocolException(400, "Request body not supported for " + method);
        }
    }

    private HttpApiResponse execute(String method, HttpApiRequest httpApiRequest, final BaseRequestItem requestItem) {
        if (httpApiRequest.href == null) {
            throw new ProtocolException(400, "href parameter is missing");
        }
        Uri href = this.normalizeUrl(httpApiRequest.href);
        try {
            String updatedAuthToken;
            HttpRequest req = new HttpRequest(href);
            req.setMethod(method);
            if (httpApiRequest.body != null) {
                req.setPostBody(httpApiRequest.body.getBytes());
            }
            for (Map.Entry<String, List<String>> header : httpApiRequest.headers.entrySet()) {
                if (BAD_HEADERS.contains(header.getKey().trim().toUpperCase())) continue;
                for (String value : header.getValue()) {
                    req.addHeader(header.getKey(), value);
                }
            }
            final Uri gadgetUri = this.getGadgetUri(requestItem.getToken(), httpApiRequest);
            if (gadgetUri == null) {
                throw new ProtocolException(400, "Gadget URI not specified in request");
            }
            req.setGadget(gadgetUri);
            if (httpApiRequest.authz != null) {
                req.setAuthType(AuthType.parse(httpApiRequest.authz));
            }
            req.setSecurityToken(requestItem.getToken());
            AuthType authType = req.getAuthType();
            if (authType != AuthType.NONE) {
                Map<String, String> authSettings;
                if (authType == AuthType.OAUTH2) {
                    authSettings = this.getAuthSettings(requestItem);
                    OAuth2Arguments oauth2Args = new OAuth2Arguments(req.getAuthType(), authSettings);
                    req.setOAuth2Arguments(oauth2Args);
                } else {
                    authSettings = this.getAuthSettings(requestItem);
                    OAuthArguments oauthArgs = new OAuthArguments(req.getAuthType(), authSettings);
                    oauthArgs.setSignOwner(httpApiRequest.signOwner);
                    oauthArgs.setSignViewer(httpApiRequest.signViewer);
                    req.setOAuthArguments(oauthArgs);
                }
            }
            req.setIgnoreCache(httpApiRequest.noCache);
            req.setSanitizationRequested(httpApiRequest.sanitize);
            if (httpApiRequest.refreshInterval != null) {
                req.setCacheTtl(httpApiRequest.refreshInterval);
            }
            final HttpRequest request = req;
            HttpResponse results = this.requestPipeline.execute(req);
            GadgetContext context = new GadgetContext(){

                @Override
                public Uri getUrl() {
                    return gadgetUri;
                }

                @Override
                public String getParameter(String key) {
                    return request.getParam(key);
                }

                @Override
                public boolean getIgnoreCache() {
                    return request.getIgnoreCache();
                }

                @Override
                public String getContainer() {
                    return requestItem.getToken().getContainer();
                }

                @Override
                public boolean getDebug() {
                    return "1".equalsIgnoreCase(this.getParameter(UriCommon.Param.DEBUG.getKey()));
                }
            };
            try {
                Gadget gadget = this.processor.process(context);
                results = this.contentRewriterRegistry.rewriteHttpResponse(req, results, gadget);
            }
            catch (ProcessingException e) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.logp(Level.WARNING, CLASSNAME, "execute", "gadgetCreationError", e);
                }
                results = this.contentRewriterRegistry.rewriteHttpResponse(req, results, null);
            }
            HttpApiResponse httpApiResponse = new HttpApiResponse(results, this.transformBody(httpApiRequest, results), httpApiRequest);
            if (requestItem.getToken() != null && (updatedAuthToken = requestItem.getToken().getUpdatedToken()) != null) {
                httpApiResponse.token = updatedAuthToken;
            }
            return httpApiResponse;
        }
        catch (GadgetException ge) {
            throw new ProtocolException(ge.getHttpStatusCode(), ge.getMessage(), (Throwable)ge);
        }
        catch (RewritingException re) {
            throw new ProtocolException(re.getHttpStatusCode(), re.getMessage(), (Throwable)re);
        }
    }

    private Map<String, String> getAuthSettings(BaseRequestItem requestItem) {
        Set allParameters = ((Map)requestItem.getTypedRequest(Map.class)).keySet();
        HashMap authSettings = Maps.newHashMap();
        for (String paramName : allParameters) {
            if (HttpApiRequest.KNOWN_PARAMETERS.contains(paramName)) continue;
            authSettings.put(paramName, requestItem.getParameter(paramName));
        }
        return authSettings;
    }

    protected Uri normalizeUrl(Uri url) {
        if (url.getScheme() == null) {
            url = new UriBuilder(url).setScheme("http").toUri();
        }
        if (url.getPath() == null || url.getPath().length() == 0) {
            url = new UriBuilder(url).setPath("/").toUri();
        }
        return url;
    }

    protected Object transformBody(HttpApiRequest request, HttpResponse results) throws GadgetException {
        String body = results.getResponseAsString();
        if ("feed".equalsIgnoreCase(request.format)) {
            return this.processFeed(request, body);
        }
        if ("json".equalsIgnoreCase(request.format)) {
            try {
                body = body.trim();
                if (body.length() > 0 && body.charAt(0) == '[') {
                    return new JSONArray(body);
                }
                return new JSONObject(body);
            }
            catch (JSONException e) {
                throw new ProtocolException(406, "Response not valid JSON", (Throwable)e);
            }
        }
        return body;
    }

    protected Object processFeed(HttpApiRequest req, String responseBody) throws GadgetException {
        return ((FeedProcessor)this.feedProcessorProvider.get()).process(req.href.toString(), responseBody, req.summarize, req.entryCount);
    }

    protected Uri getGadgetUri(SecurityToken token, HttpApiRequest httpApiRequest) {
        if (token != null && token.getAppUrl() != null) {
            return Uri.parse((String)token.getAppUrl());
        }
        return null;
    }

    public static class HttpApiResponse {
        int status;
        Map<String, Collection<String>> headers;
        Object content;
        String token;
        Map<String, String> metadata;

        public HttpApiResponse(int status) {
            this.status = status;
        }

        public HttpApiResponse(HttpResponse response, Object content, HttpApiRequest httpApiRequest) {
            this.status = response.getHttpStatusCode();
            this.headers = new TreeMap<String, Collection<String>>(String.CASE_INSENSITIVE_ORDER);
            if (response.getHeaders().containsKey((Object)"set-cookie")) {
                this.headers.put("set-cookie", response.getHeaders("set-cookie"));
            }
            if (response.getHeaders().containsKey((Object)"location")) {
                this.headers.put("location", response.getHeaders("location"));
            }
            this.content = content;
            this.metadata = response.getMetadata();
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public Map<String, Collection<String>> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Map<String, Collection<String>> headers) {
            this.headers = headers;
        }

        public Object getContent() {
            return this.content;
        }

        public void setContent(Object content) {
            this.content = content;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public Map<String, String> getMetadata() {
            if (this.metadata != null && this.metadata.isEmpty()) {
                return null;
            }
            return this.metadata;
        }

        public void setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
        }
    }

    public static class HttpApiRequest {
        static final Set<String> KNOWN_PARAMETERS = ImmutableSet.of((Object)"alias", (Object)"href", (Object)"headers", (Object)"body", (Object)"gadget", (Object)"authz", (Object[])new String[]{"sign_owner", "sign_viewer", "format", "refreshInterval", "noCache", "sanitize", "summarize", "entryCount"});
        Uri href;
        Map<String, List<String>> headers = Maps.newHashMap();
        String body;
        String authz = "none";
        boolean signOwner = true;
        boolean signViewer = true;
        String format;
        Integer refreshInterval;
        boolean noCache;
        boolean sanitize;
        boolean summarize;
        int entryCount = 3;

        public Uri getHref() {
            return this.href;
        }

        public void setHref(Uri url) {
            this.href = url;
        }

        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Map<String, List<String>> headers) {
            this.headers = headers;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public Integer getRefreshInterval() {
            return this.refreshInterval;
        }

        public void setRefreshInterval(Integer refreshInterval) {
            this.refreshInterval = refreshInterval;
        }

        public boolean isNoCache() {
            return this.noCache;
        }

        public void setNoCache(boolean noCache) {
            this.noCache = noCache;
        }

        public boolean isSanitize() {
            return this.sanitize;
        }

        public void setSanitize(boolean sanitize) {
            this.sanitize = sanitize;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public String getAuthz() {
            return this.authz;
        }

        public void setAuthz(String authz) {
            this.authz = authz;
        }

        public boolean isSignViewer() {
            return this.signViewer;
        }

        @JsonProperty(value="sign_viewer")
        public void setSignViewer(boolean signViewer) {
            this.signViewer = signViewer;
        }

        public boolean isSignOwner() {
            return this.signOwner;
        }

        @JsonProperty(value="sign_owner")
        public void setSignOwner(boolean signOwner) {
            this.signOwner = signOwner;
        }

        public boolean isSummarize() {
            return this.summarize;
        }

        public void setSummarize(boolean summarize) {
            this.summarize = summarize;
        }

        public int getEntryCount() {
            return this.entryCount;
        }

        public void setEntryCount(int entryCount) {
            this.entryCount = entryCount;
        }
    }
}

