/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse;

import com.google.inject.Provider;
import java.io.IOException;
import java.io.StringWriter;
import org.apache.shindig.gadgets.parse.AbstractParserAndSerializerTest;
import org.apache.shindig.gadgets.parse.CompactHtmlSerializer;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.HtmlSerializer;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.parse.nekohtml.NekoHtmlParser;

public class CompactHtmlSerializerTest
extends AbstractParserAndSerializerTest {
    private NekoHtmlParser full = new NekoHtmlParser(new ParseModule.DOMImplementationProvider().get());

    public void setUp() throws Exception {
        this.full.setSerializerProvider((Provider)new Provider<HtmlSerializer>(){

            public HtmlSerializer get() {
                return new CompactHtmlSerializer();
            }
        });
    }

    public void testWhitespaceNotCollapsedInSpecialTags() throws Exception {
        String content = this.loadFile("org/apache/shindig/gadgets/parse/nekohtml/test-with-specialtags.html");
        String expected = this.loadFile("org/apache/shindig/gadgets/parse/nekohtml/test-with-specialtags-expected.html");
        this.parseAndCompareBalanced(content, expected, (GadgetHtmlParser)this.full);
    }

    public void testIeConditionalCommentNotRemoved() throws Exception {
        String content = this.loadFile("org/apache/shindig/gadgets/parse/nekohtml/test-with-iecond-comments.html");
        String expected = this.loadFile("org/apache/shindig/gadgets/parse/nekohtml/test-with-iecond-comments-expected.html");
        this.parseAndCompareBalanced(content, expected, (GadgetHtmlParser)this.full);
    }

    public void testSpecialTagsAreRecognized() {
        CompactHtmlSerializerTest.assertSpecialTag("textArea");
        CompactHtmlSerializerTest.assertSpecialTag("scrIpt");
        CompactHtmlSerializerTest.assertSpecialTag("Style");
        CompactHtmlSerializerTest.assertSpecialTag("pRe");
    }

    private static void assertSpecialTag(String tagName) {
        CompactHtmlSerializerTest.assertTrue((String)(tagName + "should be special tag"), (boolean)CompactHtmlSerializer.isSpecialTag((String)tagName));
        CompactHtmlSerializerTest.assertTrue((String)(tagName.toUpperCase() + " should be special tag"), (boolean)CompactHtmlSerializer.isSpecialTag((String)tagName.toUpperCase()));
        CompactHtmlSerializerTest.assertTrue((String)(tagName.toLowerCase() + "should be special tag"), (boolean)CompactHtmlSerializer.isSpecialTag((String)tagName.toLowerCase()));
    }

    public void testCollapseHtmlWhitespace() throws IOException {
        CompactHtmlSerializerTest.assertCollapsed("abc", "abc");
        CompactHtmlSerializerTest.assertCollapsed("abc ", "abc");
        CompactHtmlSerializerTest.assertCollapsed(" abc", "abc");
        CompactHtmlSerializerTest.assertCollapsed("  abc", "abc");
        CompactHtmlSerializerTest.assertCollapsed("abc \r", "abc");
        CompactHtmlSerializerTest.assertCollapsed("a\t bc", "a bc");
        CompactHtmlSerializerTest.assertCollapsed("a  b\n\r  c", "a b c");
        CompactHtmlSerializerTest.assertCollapsed(" \ra \tb  \n c  ", "a b c");
        CompactHtmlSerializerTest.assertCollapsed(" \n\t\r ", "");
    }

    private static void assertCollapsed(String input, String expected) throws IOException {
        StringWriter output = new StringWriter();
        CompactHtmlSerializer.collapseWhitespace((String)input, (Appendable)output);
        CompactHtmlSerializerTest.assertEquals((String)expected, (String)((Object)output).toString());
    }
}

