/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.image;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.imageio.ImageIO;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.rewrite.image.BasicImageRewriter;
import org.apache.shindig.gadgets.rewrite.image.ImageRewriter;
import org.apache.shindig.gadgets.rewrite.image.OptimizerConfig;
import org.easymock.IMocksControl;
import org.easymock.classextension.EasyMock;

public class ImageRewriterTest
extends TestCase {
    private static final String SCALE_IMAGE = "org/apache/shindig/gadgets/rewrite/image/dog.gif";
    private static final String EXPAND_IMAGE = "org/apache/shindig/gadgets/rewrite/image/expand.gif";
    private static final String HUGE_IMAGE = "org/apache/shindig/gadgets/rewrite/image/huge.gif";
    private static final String CONTENT_TYPE_BOGUS = "notimage/anything";
    private static final String CONTENT_TYPE_JPG = "image/jpeg";
    private static final String CONTENT_TYPE_GIF = "image/gif";
    private static final String CONTENT_TYPE_PNG = "image/png";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final Uri IMAGE_URL = Uri.parse((String)"http://www.example.com/image.gif");
    private ImageRewriter rewriter;
    private IMocksControl mockControl;

    public void setUp() throws Exception {
        this.rewriter = new BasicImageRewriter(new OptimizerConfig());
        this.mockControl = EasyMock.createControl();
    }

    private HttpResponse getImageResponse(String contentType, byte[] imageBytes) {
        HttpResponse originalResponse = new HttpResponseBuilder().setHeader(CONTENT_TYPE_HEADER, contentType).setHttpStatusCode(200).setResponse(imageBytes).create();
        return originalResponse;
    }

    private byte[] getImageBytes(String imageResourceName) throws IOException {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        byte[] imageBytes = IOUtils.toByteArray((InputStream)classLoader.getResourceAsStream(imageResourceName));
        ImageRewriterTest.assertNotNull((Object)imageBytes);
        return imageBytes;
    }

    private BufferedImage getResizedHttpResponseContent(String sourceContentType, String targetContentType, String imageName, Integer width, Integer height, Integer quality) throws Exception {
        HttpResponse originalResponse = this.getImageResponse(sourceContentType, this.getImageBytes(imageName));
        HttpRequest request = this.getMockRequest(width, height, quality);
        this.mockControl.replay();
        HttpResponse rewrittenResponse = this.rewriter.rewrite(request, originalResponse);
        this.mockControl.verify();
        ImageRewriterTest.assertEquals((String)targetContentType, (String)rewrittenResponse.getHeader(CONTENT_TYPE_HEADER));
        return ImageIO.read(rewrittenResponse.getResponse());
    }

    private HttpRequest getMockRequest(Integer width, Integer height, Integer quality) {
        HttpRequest request = (HttpRequest)this.mockControl.createMock(HttpRequest.class);
        org.easymock.EasyMock.expect((Object)request.getUri()).andReturn((Object)IMAGE_URL);
        org.easymock.EasyMock.expect((Object)request.getParamAsInteger("resize_q")).andReturn((Object)quality);
        org.easymock.EasyMock.expect((Object)request.getParamAsInteger("resize_w")).andReturn((Object)width);
        org.easymock.EasyMock.expect((Object)request.getParamAsInteger("resize_h")).andReturn((Object)height);
        return request;
    }

    public void testRewriteValidImageWithValidMimeAndExtn() throws Exception {
        byte[] bytes = this.getImageBytes("org/apache/shindig/gadgets/rewrite/image/inefficient.png");
        HttpResponse original = this.getImageResponse(CONTENT_TYPE_PNG, bytes);
        HttpResponse rewritten = this.rewriter.rewrite(new HttpRequest(Uri.parse((String)"some.png")), original);
        ImageRewriterTest.assertEquals((int)rewritten.getHttpStatusCode(), (int)200);
        ImageRewriterTest.assertTrue((rewritten.getContentLength() < original.getContentLength() ? 1 : 0) != 0);
    }

    public void testRewriteValidImageWithInvalidMimeAndFileExtn() throws Exception {
        byte[] bytes = this.getImageBytes("org/apache/shindig/gadgets/rewrite/image/inefficient.png");
        HttpResponse original = this.getImageResponse(CONTENT_TYPE_BOGUS, bytes);
        HttpResponse rewritten = this.rewriter.rewrite(new HttpRequest(Uri.parse((String)"some.junk")), original);
        ImageRewriterTest.assertEquals((int)200, (int)rewritten.getHttpStatusCode());
        ImageRewriterTest.assertEquals((int)rewritten.getContentLength(), (int)original.getContentLength());
    }

    public void testRewriteInvalidImageContentWithValidMime() throws Exception {
        HttpResponse original = this.getImageResponse(CONTENT_TYPE_PNG, "This is not a PNG".getBytes());
        HttpResponse rewritten = this.rewriter.rewrite(new HttpRequest(Uri.parse((String)"some.junk")), original);
        ImageRewriterTest.assertEquals((int)415, (int)rewritten.getHttpStatusCode());
        ImageRewriterTest.assertEquals((String)"Content is not an image but mime type asserts it is", (String)rewritten.getResponseAsString());
    }

    public void testRewriteInvalidImageContentWithValidFileExtn() throws Exception {
        HttpResponse original = this.getImageResponse(CONTENT_TYPE_BOGUS, "This is not an image".getBytes());
        HttpResponse rewritten = this.rewriter.rewrite(new HttpRequest(Uri.parse((String)"some.png")), original);
        ImageRewriterTest.assertEquals((int)415, (int)rewritten.getHttpStatusCode());
        ImageRewriterTest.assertEquals((String)"Content is not an image but file extension asserts it is", (String)rewritten.getResponseAsString());
    }

    public void testNoRewriteAnimatedGIF() throws Exception {
        HttpResponse original = this.getImageResponse(CONTENT_TYPE_GIF, this.getImageBytes("org/apache/shindig/gadgets/rewrite/image/animated.gif"));
        ImageRewriterTest.assertSame((Object)this.rewriter.rewrite(new HttpRequest(Uri.parse((String)"animated.gif")), original), (Object)original);
    }

    public void testRewriteUnAnimatedGIF() throws Exception {
        HttpResponse original = this.getImageResponse(CONTENT_TYPE_GIF, this.getImageBytes("org/apache/shindig/gadgets/rewrite/image/large.gif"));
        ImageRewriterTest.assertEquals((String)CONTENT_TYPE_PNG, (String)this.rewriter.rewrite(new HttpRequest(Uri.parse((String)"large.gif")), original).getHeader(CONTENT_TYPE_HEADER));
    }

    public void testResize_width() throws Exception {
        BufferedImage image = this.getResizedHttpResponseContent(CONTENT_TYPE_GIF, CONTENT_TYPE_JPG, SCALE_IMAGE, 100, null, null);
        ImageRewriterTest.assertEquals((int)100, (int)image.getWidth());
        ImageRewriterTest.assertEquals((int)100, (int)image.getHeight());
    }

    public void testResize_height() throws Exception {
        BufferedImage image = this.getResizedHttpResponseContent(CONTENT_TYPE_GIF, CONTENT_TYPE_JPG, SCALE_IMAGE, null, 100, null);
        ImageRewriterTest.assertEquals((int)100, (int)image.getWidth());
        ImageRewriterTest.assertEquals((int)100, (int)image.getHeight());
    }

    public void testResize_both() throws Exception {
        BufferedImage image = this.getResizedHttpResponseContent(CONTENT_TYPE_GIF, CONTENT_TYPE_JPG, SCALE_IMAGE, 100, 100, null);
        ImageRewriterTest.assertEquals((int)100, (int)image.getWidth());
        ImageRewriterTest.assertEquals((int)100, (int)image.getHeight());
    }

    public void testResize_all() throws Exception {
        BufferedImage image = this.getResizedHttpResponseContent(CONTENT_TYPE_GIF, CONTENT_TYPE_JPG, SCALE_IMAGE, 100, 100, 10);
        ImageRewriterTest.assertEquals((int)100, (int)image.getWidth());
        ImageRewriterTest.assertEquals((int)100, (int)image.getHeight());
    }

    public void testResize_wideImage() throws Exception {
        BufferedImage image = this.getResizedHttpResponseContent(CONTENT_TYPE_GIF, CONTENT_TYPE_JPG, SCALE_IMAGE, 100, 50, null);
        ImageRewriterTest.assertEquals((int)100, (int)image.getWidth());
        ImageRewriterTest.assertEquals((int)50, (int)image.getHeight());
    }

    public void testResize_tallImage() throws Exception {
        BufferedImage image = this.getResizedHttpResponseContent(CONTENT_TYPE_GIF, CONTENT_TYPE_JPG, SCALE_IMAGE, 50, 100, null);
        ImageRewriterTest.assertEquals((int)50, (int)image.getWidth());
        ImageRewriterTest.assertEquals((int)100, (int)image.getHeight());
    }

    public void testResize_skipResizeHugeOutputImage() throws Exception {
        BufferedImage image = this.getResizedHttpResponseContent(CONTENT_TYPE_GIF, CONTENT_TYPE_JPG, SCALE_IMAGE, 10000, 10000, null);
        ImageRewriterTest.assertEquals((int)500, (int)image.getWidth());
        ImageRewriterTest.assertEquals((int)500, (int)image.getHeight());
    }

    public void testResize_brokenParameter() throws Exception {
        BufferedImage image = this.getResizedHttpResponseContent(CONTENT_TYPE_GIF, CONTENT_TYPE_GIF, SCALE_IMAGE, -1, null, null);
        ImageRewriterTest.assertEquals((int)500, (int)image.getWidth());
        ImageRewriterTest.assertEquals((int)500, (int)image.getHeight());
    }

    public void testResize_expandImage() throws Exception {
        BufferedImage image = this.getResizedHttpResponseContent(CONTENT_TYPE_GIF, CONTENT_TYPE_JPG, EXPAND_IMAGE, 120, 60, null);
        ImageRewriterTest.assertEquals((int)120, (int)image.getWidth());
        ImageRewriterTest.assertEquals((int)60, (int)image.getHeight());
    }

    public void testResize_refuseHugeInputImages() throws Exception {
        HttpResponse originalResponse = this.getImageResponse(CONTENT_TYPE_GIF, this.getImageBytes(HUGE_IMAGE));
        HttpRequest request = this.getMockRequest(120, 60, null);
        this.mockControl.replay();
        HttpResponse rewrittenResponse = this.rewriter.rewrite(request, originalResponse);
        this.mockControl.verify();
        ImageRewriterTest.assertEquals((int)403, (int)rewrittenResponse.getHttpStatusCode());
    }

    public void testResize_acceptServeHugeImages() throws Exception {
        byte[] imageBytes = this.getImageBytes(HUGE_IMAGE);
        HttpResponse originalResponse = this.getImageResponse(CONTENT_TYPE_GIF, imageBytes);
        HttpRequest request = this.getMockRequest(null, null, null);
        this.mockControl.replay();
        HttpResponse rewrittenResponse = this.rewriter.rewrite(request, originalResponse);
        this.mockControl.verify();
        ImageRewriterTest.assertEquals((int)200, (int)rewrittenResponse.getHttpStatusCode());
        ImageRewriterTest.assertTrue((boolean)Arrays.equals(imageBytes, IOUtils.toByteArray((InputStream)rewrittenResponse.getResponse())));
    }
}

