/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.gadgets.oauth.OAuthCallbackState;
import org.apache.shindig.gadgets.servlet.OAuthCallbackServlet;
import org.apache.shindig.gadgets.servlet.ServletTestFixture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class OAuthCallbackServletTest
extends ServletTestFixture {
    @Test
    public void testServlet() throws Exception {
        OAuthCallbackServlet servlet = new OAuthCallbackServlet();
        this.replay();
        servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        OAuthCallbackServletTest.assertEquals((String)"text/html; charset=UTF-8", (String)this.recorder.getContentType());
        String body = this.recorder.getResponseAsString();
        Assert.assertNotSame((String)("body is " + body), (Object)body.indexOf("window.close()"), (Object)-1);
    }

    @Test
    public void testServletWithCallback() throws Exception {
        BasicBlobCrypter crypter = new BasicBlobCrypter("00000000000000000000".getBytes());
        OAuthCallbackState state = new OAuthCallbackState((BlobCrypter)crypter);
        OAuthCallbackServlet servlet = new OAuthCallbackServlet();
        servlet.setStateCrypter((BlobCrypter)crypter);
        state.setRealCallbackUrl("http://www.example.com/callback");
        EasyMock.expect((Object)this.request.getParameter("cs")).andReturn((Object)state.getEncryptedState());
        EasyMock.expect((Object)this.request.getQueryString()).andReturn((Object)"cs=foo&bar=baz");
        this.replay();
        servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        OAuthCallbackServletTest.assertEquals((int)302, (int)this.recorder.getHttpStatusCode());
        OAuthCallbackServletTest.assertEquals((String)"http://www.example.com/callback?bar=baz", (String)this.recorder.getHeader("Location"));
        String cacheControl = this.recorder.getHeader("Cache-Control");
        OAuthCallbackServletTest.assertEquals((String)"private,max-age=3600", (String)cacheControl);
    }

    @Test
    public void testServletWithCallback_noQueryParams() throws Exception {
        BasicBlobCrypter crypter = new BasicBlobCrypter("00000000000000000000".getBytes());
        OAuthCallbackState state = new OAuthCallbackState((BlobCrypter)crypter);
        OAuthCallbackServlet servlet = new OAuthCallbackServlet();
        servlet.setStateCrypter((BlobCrypter)crypter);
        state.setRealCallbackUrl("http://www.example.com/callback");
        EasyMock.expect((Object)this.request.getParameter("cs")).andReturn((Object)state.getEncryptedState());
        EasyMock.expect((Object)this.request.getQueryString()).andReturn((Object)"cs=foo");
        this.replay();
        servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        OAuthCallbackServletTest.assertEquals((int)302, (int)this.recorder.getHttpStatusCode());
        OAuthCallbackServletTest.assertEquals((String)"http://www.example.com/callback", (String)this.recorder.getHeader("Location"));
        String cacheControl = this.recorder.getHeader("Cache-Control");
        OAuthCallbackServletTest.assertEquals((String)"private,max-age=3600", (String)cacheControl);
    }
}

