/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import javax.servlet.http.HttpServletResponse;
import junitx.framework.StringAssert;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.servlet.ProxyHandler;
import org.apache.shindig.gadgets.servlet.ProxyServlet;
import org.apache.shindig.gadgets.servlet.ServletTestFixture;
import org.easymock.EasyMock;

public class ProxyServletTest
extends ServletTestFixture {
    private static final String REQUEST_DOMAIN = "example.org";
    private static final Uri REQUEST_URL = Uri.parse((String)"http://example.org/file");
    private static final String BASIC_SYNTAX_URL = "http://opensocial.org/proxy?foo=bar&url=" + REQUEST_URL;
    private static final String ALT_SYNTAX_URL = "http://opensocial.org/proxy/foo=bar/" + REQUEST_URL;
    private static final String RESPONSE_BODY = "Hello, world!";
    private static final String ERROR_MESSAGE = "Broken!";
    private final ProxyHandler proxyHandler;
    private final ProxyServlet servlet;
    private final HttpRequest internalRequest;
    private final HttpResponse internalResponse;

    public ProxyServletTest() {
        this.proxyHandler = new ProxyHandler(this.pipeline, this.lockedDomainService, null);
        this.servlet = new ProxyServlet();
        this.internalRequest = new HttpRequest(REQUEST_URL);
        this.internalResponse = new HttpResponse(RESPONSE_BODY);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.servlet.setProxyHandler(this.proxyHandler);
        EasyMock.expect((Object)this.request.getParameter("url")).andReturn((Object)REQUEST_URL.toString()).anyTimes();
        EasyMock.expect((Object)this.request.getHeader("Host")).andReturn((Object)REQUEST_DOMAIN).anyTimes();
        EasyMock.expect((Object)this.lockedDomainService.isSafeForOpenProxy(REQUEST_DOMAIN)).andReturn((Object)true).anyTimes();
    }

    private void setupBasic() {
        EasyMock.expect((Object)this.request.getRequestURI()).andReturn((Object)BASIC_SYNTAX_URL);
    }

    private void setupAltSyntax() {
        EasyMock.expect((Object)this.request.getRequestURI()).andReturn((Object)ALT_SYNTAX_URL);
    }

    private void assertResponseOk(int expectedStatus, String expectedBody) {
        ProxyServletTest.assertEquals((int)expectedStatus, (int)this.recorder.getHttpStatusCode());
        ProxyServletTest.assertEquals((String)expectedBody, (String)this.recorder.getResponseAsString());
    }

    public void testDoGetNormal() throws Exception {
        this.setupBasic();
        EasyMock.expect((Object)this.pipeline.execute(this.internalRequest)).andReturn((Object)this.internalResponse);
        this.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.assertResponseOk(200, RESPONSE_BODY);
    }

    public void testDoGetHttpError() throws Exception {
        this.setupBasic();
        EasyMock.expect((Object)this.pipeline.execute(this.internalRequest)).andReturn((Object)HttpResponse.notFound());
        this.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.assertResponseOk(404, "");
    }

    public void testDoGetException() throws Exception {
        this.setupBasic();
        EasyMock.expect((Object)this.pipeline.execute(this.internalRequest)).andThrow((Throwable)new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, ERROR_MESSAGE));
        this.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        ProxyServletTest.assertEquals((int)400, (int)this.recorder.getHttpStatusCode());
        StringAssert.assertContains((String)ERROR_MESSAGE, (String)this.recorder.getResponseAsString());
    }

    public void testDoGetAlternateSyntax() throws Exception {
        this.setupAltSyntax();
        EasyMock.expect((Object)this.request.getRequestURI()).andReturn((Object)ALT_SYNTAX_URL);
        EasyMock.expect((Object)this.pipeline.execute(this.internalRequest)).andReturn((Object)this.internalResponse);
        this.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        this.assertResponseOk(200, RESPONSE_BODY);
    }
}

