/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.shindig.gadgets.parse.ParsedHtmlAttribute;
import org.apache.shindig.gadgets.parse.ParsedHtmlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseTreeSerializer {
    private static final int SERIALIZATION_VERSION_ID = 1;

    public byte[] serialize(List<ParsedHtmlNode> nodes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Object oos = null;
        try {
            SerializableParsedNode parent = SerializableParsedNode.makeParent(nodes);
            parent.writeObject(baos);
        }
        catch (IOException e) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public List<ParsedHtmlNode> deserialize(byte[] buffer) {
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
        Object ois = null;
        List<ParsedHtmlNode> nodes = null;
        try {
            SerializableParsedNode spn = SerializableParsedNode.readObject(bais);
            if (spn == null) {
                return null;
            }
            nodes = spn.getChildren();
        }
        catch (IOException e) {
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        return nodes;
    }

    private static List<SerializableParsedNode> getSerializableNodeList(List<ParsedHtmlNode> nodes) {
        if (nodes == null) {
            return null;
        }
        ArrayList<SerializableParsedNode> outNodes = new ArrayList<SerializableParsedNode>(nodes.size());
        for (ParsedHtmlNode node : nodes) {
            outNodes.add(new SerializableParsedNode(node));
        }
        return outNodes;
    }

    private static List<SerializableParsedAttrib> getSerializableAttribList(List<ParsedHtmlAttribute> attribs) {
        if (attribs == null) {
            return null;
        }
        ArrayList<SerializableParsedAttrib> outAttribs = new ArrayList<SerializableParsedAttrib>(attribs.size());
        for (ParsedHtmlAttribute attrib : attribs) {
            outAttribs.add(new SerializableParsedAttrib(attrib));
        }
        return outAttribs;
    }

    private static void writeInt(OutputStream out, int num) throws IOException {
        out.write(num >> 0);
        out.write(num >> 8);
        out.write(num >> 16);
        out.write(num >> 24);
    }

    private static int readInt(InputStream in) throws IOException {
        return in.read() << 0 | in.read() << 8 | in.read() << 16 | in.read() << 24;
    }

    private static void writeString(OutputStream out, String str) throws IOException {
        if (str == null) {
            ParseTreeSerializer.writeInt(out, 0);
            return;
        }
        byte[] utf8bytes = str.getBytes("UTF8");
        ParseTreeSerializer.writeInt(out, utf8bytes.length);
        out.write(utf8bytes, 0, utf8bytes.length);
    }

    private static String readString(InputStream in) throws IOException {
        int thisTime;
        int len = ParseTreeSerializer.readInt(in);
        if (len == 0) {
            return null;
        }
        byte[] stringBytes = new byte[len];
        for (int read = 0; read < len; read += thisTime) {
            thisTime = in.read(stringBytes, read, len - read);
            if (thisTime != -1) continue;
            throw new IOException("Insufficient data in buffer to read");
        }
        return new String(stringBytes, "UTF8");
    }

    private static class SerializableParsedAttrib
    implements ParsedHtmlAttribute {
        private String name;
        private String value;

        private SerializableParsedAttrib(ParsedHtmlAttribute source) {
            this.name = source.getName();
            this.value = source.getValue();
        }

        private SerializableParsedAttrib(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void writeObject(OutputStream out) throws IOException {
            ParseTreeSerializer.writeString(out, this.name);
            ParseTreeSerializer.writeString(out, this.value);
        }

        private static SerializableParsedAttrib readObject(InputStream in) throws IOException {
            return new SerializableParsedAttrib(ParseTreeSerializer.readString(in), ParseTreeSerializer.readString(in));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializableParsedNode
    implements ParsedHtmlNode {
        private String tag;
        private List<SerializableParsedAttrib> sattribs;
        private List<ParsedHtmlAttribute> attribs;
        private List<SerializableParsedNode> schildren;
        private List<ParsedHtmlNode> children;
        private String text;

        @Override
        public List<ParsedHtmlAttribute> getAttributes() {
            if (this.attribs == null) {
                this.attribs = new ArrayList<ParsedHtmlAttribute>(this.sattribs.size());
                this.attribs.addAll(this.sattribs);
            }
            return this.attribs;
        }

        @Override
        public List<ParsedHtmlNode> getChildren() {
            if (this.children == null) {
                this.children = new ArrayList<ParsedHtmlNode>(this.schildren.size());
                this.children.addAll(this.schildren);
            }
            return this.children;
        }

        @Override
        public String getTagName() {
            return this.tag;
        }

        @Override
        public String getText() {
            return this.text;
        }

        private void writeObject(OutputStream out) throws IOException {
            ParseTreeSerializer.writeInt(out, 1);
            if (this.tag != null) {
                out.write(1);
                ParseTreeSerializer.writeString(out, this.tag);
                ParseTreeSerializer.writeInt(out, this.sattribs.size());
                for (SerializableParsedAttrib attrib : this.sattribs) {
                    attrib.writeObject(out);
                }
                ParseTreeSerializer.writeInt(out, this.schildren.size());
                for (SerializableParsedNode node : this.schildren) {
                    node.writeObject(out);
                }
            } else {
                out.write(0);
                ParseTreeSerializer.writeString(out, this.text);
            }
        }

        private static SerializableParsedNode readObject(InputStream in) throws IOException {
            boolean isTag;
            int writtenVersion = ParseTreeSerializer.readInt(in);
            if (writtenVersion != 1) {
                return null;
            }
            boolean bl = isTag = in.read() != 0;
            if (isTag) {
                String tag = ParseTreeSerializer.readString(in);
                try {
                    int attribLen = ParseTreeSerializer.readInt(in);
                    ArrayList<SerializableParsedAttrib> sattribs = new ArrayList<SerializableParsedAttrib>(attribLen);
                    for (int i = 0; i < attribLen; ++i) {
                        sattribs.add(SerializableParsedAttrib.readObject(in));
                    }
                    int childLen = ParseTreeSerializer.readInt(in);
                    ArrayList<SerializableParsedNode> schildren = new ArrayList<SerializableParsedNode>(childLen);
                    for (int i = 0; i < childLen; ++i) {
                        schildren.add(SerializableParsedNode.readObject(in));
                    }
                    return new SerializableParsedNode(tag, sattribs, schildren);
                }
                catch (ClassCastException e) {
                    throw new IOException("Class cast exception reading object: " + e);
                }
            }
            return new SerializableParsedNode(ParseTreeSerializer.readString(in));
        }

        private static SerializableParsedNode makeParent(List<ParsedHtmlNode> kids) {
            return new SerializableParsedNode("x", new ArrayList<SerializableParsedAttrib>(), ParseTreeSerializer.getSerializableNodeList(kids));
        }

        private SerializableParsedNode(ParsedHtmlNode source) {
            this.tag = source.getTagName();
            this.sattribs = ParseTreeSerializer.getSerializableAttribList(source.getAttributes());
            this.schildren = ParseTreeSerializer.getSerializableNodeList(source.getChildren());
            this.text = source.getText();
        }

        private SerializableParsedNode(String tag, List<SerializableParsedAttrib> sattribs, List<SerializableParsedNode> schildren) {
            this.tag = tag;
            this.sattribs = sattribs;
            this.schildren = schildren;
        }

        private SerializableParsedNode(String text) {
            this.text = text;
        }
    }
}

