/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.shindig.common.util.Utf8UrlCoder;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.LinkRewriter;

public class ProxyingLinkRewriter
implements LinkRewriter {
    private final String prefix;
    private final ContentRewriterFeature rewriterFeature;
    private final URI gadgetUri;

    public ProxyingLinkRewriter(URI gadgetUri, ContentRewriterFeature rewriterFeature, String prefix) {
        this.prefix = prefix;
        this.rewriterFeature = rewriterFeature;
        this.gadgetUri = gadgetUri;
    }

    public String rewrite(String link, URI context) {
        if ((link = link.trim()).length() == 0) {
            return link;
        }
        try {
            URI linkUri = new URI(link);
            URI uri = context.resolve(linkUri);
            if (this.rewriterFeature.shouldRewriteURL(uri.toString())) {
                String result = this.prefix + Utf8UrlCoder.encode((String)uri.toString()) + "&gadget=" + Utf8UrlCoder.encode((String)this.gadgetUri.toString()) + "&fp=" + this.rewriterFeature.getFingerprint();
                if (this.rewriterFeature.getExpires() != null) {
                    result = result + "&refresh=" + this.rewriterFeature.getExpires().toString();
                }
                return result;
            }
            return uri.toString();
        }
        catch (URISyntaxException use) {
            return link;
        }
    }
}

