/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import java.net.URI;
import java.util.LinkedList;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.parse.GadgetHtmlNode;
import org.apache.shindig.gadgets.rewrite.ContentRewriter;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.CssRewriter;
import org.apache.shindig.gadgets.rewrite.HtmlContentRewriter;
import org.apache.shindig.gadgets.rewrite.LinkRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.RewriterResults;
import org.apache.shindig.gadgets.spec.View;

public class StyleLinksContentRewriter
implements ContentRewriter {
    private final ContentRewriterFeature.Factory rewriterFeatureFactory;
    private final LinkRewriter linkRewriter;

    public StyleLinksContentRewriter(ContentRewriterFeature.Factory rewriterFeatureFactory, LinkRewriter linkRewriter) {
        this.rewriterFeatureFactory = rewriterFeatureFactory;
        this.linkRewriter = linkRewriter;
    }

    public RewriterResults rewrite(HttpRequest request, HttpResponse original, MutableContent content) {
        String mimeType = HtmlContentRewriter.getMimeType(request, original);
        if (mimeType.contains("html")) {
            this.rewriteHtml(content.getParseTree(), request.getUri().toJavaUri());
        } else if (mimeType.contains("css")) {
            content.setContent(this.rewriteCss(content.getContent(), request.getUri().toJavaUri()));
        }
        return RewriterResults.cacheableIndefinitely();
    }

    public RewriterResults rewrite(Gadget gadget, MutableContent content) {
        ContentRewriterFeature rewriterFeature = this.rewriterFeatureFactory.get(gadget.getSpec());
        if (this.linkRewriter == null || !rewriterFeature.isRewriteEnabled() || !rewriterFeature.getIncludedTags().contains("style")) {
            return null;
        }
        Uri base = gadget.getSpec().getUrl();
        View view = gadget.getCurrentView();
        if (view != null && view.getHref() != null) {
            base = view.getHref();
        }
        return this.rewriteHtml(content.getParseTree(), base.toJavaUri());
    }

    private RewriterResults rewriteHtml(GadgetHtmlNode root, URI baseUri) {
        if (root == null) {
            return null;
        }
        LinkedList<GadgetHtmlNode> nodesToProcess = new LinkedList<GadgetHtmlNode>();
        nodesToProcess.addAll(root.getChildren());
        while (!nodesToProcess.isEmpty()) {
            GadgetHtmlNode curNode = (GadgetHtmlNode)nodesToProcess.remove();
            if (curNode.isText()) continue;
            nodesToProcess.addAll(curNode.getChildren());
            if (!curNode.getTagName().equalsIgnoreCase("style")) continue;
            String styleText = StyleLinksContentRewriter.getNodeChildText(curNode);
            curNode.clearChildren();
            curNode.appendChild(new GadgetHtmlNode(this.rewriteCss(styleText, baseUri)));
        }
        return RewriterResults.cacheableIndefinitely();
    }

    private String rewriteCss(String styleText, URI baseUri) {
        return CssRewriter.rewrite(styleText, baseUri, this.linkRewriter);
    }

    private static String getNodeChildText(GadgetHtmlNode node) {
        StringBuilder builder = new StringBuilder();
        for (GadgetHtmlNode child : node.getChildren()) {
            if (!child.isText()) continue;
            builder.append(child.getText());
        }
        return builder.toString();
    }
}

