/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import java.util.Collection;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.common.ContainerConfig;
import org.apache.shindig.common.util.TimeSource;
import org.apache.shindig.gadgets.GadgetContext;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpUtil {
    public static final int DEFAULT_TTL = 31536000;
    private static TimeSource timeSource;
    private static long startTime;

    public static void setTimeSource(TimeSource timeSource) {
        HttpUtil.timeSource = timeSource;
        startTime = HttpUtil.timeSource.currentTimeMillis();
    }

    public static void setCachingHeaders(HttpServletResponse response) {
        HttpUtil.setCachingHeaders(response, 31536000, false);
    }

    public static void setCachingHeaders(HttpServletResponse response, boolean noProxy) {
        HttpUtil.setCachingHeaders(response, 31536000, noProxy);
    }

    public static void setCachingHeaders(HttpServletResponse response, int ttl) {
        HttpUtil.setCachingHeaders(response, ttl, false);
    }

    public static void setCachingHeaders(HttpServletResponse response, int ttl, boolean noProxy) {
        response.setDateHeader("Expires", timeSource.currentTimeMillis() + 1000L * (long)ttl);
        if (ttl == 0) {
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
        } else {
            if (noProxy) {
                response.setHeader("Cache-Control", "private,max-age=" + Integer.toString(ttl));
            } else {
                response.setHeader("Cache-Control", "public,max-age=" + Integer.toString(ttl));
            }
            response.setDateHeader("Last-Modified", startTime);
        }
    }

    public static JSONObject getJsConfig(ContainerConfig config, GadgetContext context, Collection<String> features) {
        JSONObject containerFeatures = config.getJsonObject(context.getContainer(), "gadgets.features");
        if (containerFeatures != null) {
            String[] featArray = features.toArray(new String[features.size()]);
            try {
                return new JSONObject(containerFeatures, featArray);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        return new JSONObject();
    }

    static {
        HttpUtil.setTimeSource(new TimeSource());
    }
}

