/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.ContainerConfig;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetFeature;
import org.apache.shindig.gadgets.GadgetFeatureRegistry;
import org.apache.shindig.gadgets.JsLibrary;
import org.apache.shindig.gadgets.MessageBundleFactory;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.UnsupportedFeatureException;
import org.apache.shindig.gadgets.UrlGenerator;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.preload.PreloadException;
import org.apache.shindig.gadgets.preload.Preloads;
import org.apache.shindig.gadgets.rewrite.ContentRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.RewriterResults;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.apache.shindig.gadgets.spec.MessageBundle;
import org.apache.shindig.gadgets.spec.ModulePrefs;
import org.apache.shindig.gadgets.spec.View;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderingContentRewriter
implements ContentRewriter {
    private static final Logger LOG = Logger.getLogger(RenderingContentRewriter.class.getName());
    static final Pattern DOCUMENT_SPLIT_PATTERN = Pattern.compile("(.*)<head>(.*?)<\\/head>(?:.*)<body(.*?)>(.*?)<\\/body>(?:.*)", 32);
    static final int BEFORE_HEAD_GROUP = 1;
    static final int HEAD_GROUP = 2;
    static final int BODY_ATTRIBUTES_GROUP = 3;
    static final int BODY_GROUP = 4;
    static final String DEFAULT_HEAD_CONTENT = "<style type=\"text/css\">body,td,div,span,p{font-family:arial,sans-serif;}a {color:#0000cc;}a:visited {color:#551a8b;}a:active {color:#ff0000;}body{margin: 0px;padding: 0px;background-color:white;}</style>";
    private final MessageBundleFactory messageBundleFactory;
    private final ContainerConfig containerConfig;
    private final GadgetFeatureRegistry featureRegistry;
    private final UrlGenerator urlGenerator;

    @Inject
    public RenderingContentRewriter(MessageBundleFactory messageBundleFactory, ContainerConfig containerConfig, GadgetFeatureRegistry featureRegistry, UrlGenerator urlGenerator) {
        this.messageBundleFactory = messageBundleFactory;
        this.containerConfig = containerConfig;
        this.featureRegistry = featureRegistry;
        this.urlGenerator = urlGenerator;
    }

    @Override
    public RewriterResults rewrite(HttpRequest req, HttpResponse resp, MutableContent content) {
        return RewriterResults.cacheableIndefinitely();
    }

    @Override
    public RewriterResults rewrite(Gadget gadget, MutableContent mutableContent) {
        try {
            GadgetContent content = this.createGadgetContent(gadget, mutableContent);
            this.injectBaseTag(gadget, content);
            this.injectFeatureLibraries(gadget, content);
            content.appendHead("<script>");
            this.injectMessageBundles(gadget, content);
            this.injectPreloads(gadget, content);
            content.appendHead("</script>");
            this.injectOnLoadHandlers(content);
            mutableContent.setContent(this.finalizeDocument(gadget, content));
            return RewriterResults.notCacheable();
        }
        catch (GadgetException e) {
            throw new RuntimeException(e);
        }
    }

    private void injectBaseTag(Gadget gadget, GadgetContent content) {
        Uri base = gadget.getSpec().getUrl();
        View view = gadget.getCurrentView();
        if (view != null && view.getHref() != null) {
            base = view.getHref();
        }
        content.appendHead("<base href='" + base + "'/>");
    }

    private void injectOnLoadHandlers(GadgetContent content) {
        content.appendBody("<script>gadgets.util.runOnLoadHandlers();</script>");
    }

    private void injectFeatureLibraries(Gadget gadget, GadgetContent content) throws GadgetException {
        GadgetContext context = gadget.getContext();
        GadgetSpec spec = gadget.getSpec();
        String forcedLibs = context.getParameter("libs");
        HashSet forced = forcedLibs == null || forcedLibs.length() == 0 ? Sets.newHashSet() : Sets.newHashSet((Object[])forcedLibs.split(":"));
        String externFmt = "<script src=\"%s\"></script>";
        if (!forced.isEmpty()) {
            String jsUrl = this.urlGenerator.getBundledJsUrl(forced, context);
            content.appendHead(String.format(externFmt, jsUrl));
            for (GadgetFeature dep : this.featureRegistry.getFeatures(forced)) {
                forced.add(dep.getName());
            }
        }
        StringBuilder inlineJs = new StringBuilder();
        String container = context.getContainer();
        Collection<GadgetFeature> features = this.getFeatures(spec, forced);
        for (GadgetFeature feature : features) {
            for (JsLibrary library : feature.getJsLibraries(RenderingContext.GADGET, container)) {
                if (library.getType().equals((Object)JsLibrary.Type.URL)) {
                    if (inlineJs.length() > 0) {
                        content.appendHead("<script>").appendHead(inlineJs).appendHead("</script>");
                        inlineJs.setLength(0);
                    }
                    content.appendHead(String.format(externFmt, library.getContent()));
                    continue;
                }
                if (forced.contains(feature.getName())) continue;
                if (context.getDebug()) {
                    inlineJs.append(library.getDebugContent());
                } else {
                    inlineJs.append(library.getContent());
                }
                inlineJs.append(";\n");
            }
        }
        inlineJs.append(this.getLibraryConfig(gadget, features));
        if (inlineJs.length() > 0) {
            content.appendHead("<script>").appendHead(inlineJs).appendHead("</script>");
        }
    }

    private Collection<GadgetFeature> getFeatures(GadgetSpec spec, Collection<String> forced) throws GadgetException {
        Map<String, Feature> features = spec.getModulePrefs().getFeatures();
        HashSet libs = Sets.newHashSet(features.keySet());
        if (!forced.isEmpty()) {
            libs.addAll(forced);
        }
        HashSet<String> unsupported = new HashSet<String>();
        Collection<GadgetFeature> feats = this.featureRegistry.getFeatures(libs, unsupported);
        unsupported.removeAll(forced);
        if (!unsupported.isEmpty()) {
            Iterator missingIter = unsupported.iterator();
            while (missingIter.hasNext()) {
                String missing = (String)missingIter.next();
                if (features.get(missing).getRequired()) continue;
                missingIter.remove();
            }
            if (!unsupported.isEmpty()) {
                throw new UnsupportedFeatureException(((Object)unsupported).toString());
            }
        }
        return feats;
    }

    private String getLibraryConfig(Gadget gadget, Collection<GadgetFeature> reqs) throws GadgetException {
        GadgetContext context = gadget.getContext();
        JSONObject features = this.containerConfig.getJsonObject(context.getContainer(), "gadgets.features");
        try {
            JSONObject config;
            if (features == null) {
                config = new JSONObject();
            } else {
                String[] properties = new String[reqs.size()];
                int i = 0;
                for (GadgetFeature gadgetFeature : reqs) {
                    properties[i++] = gadgetFeature.getName();
                }
                config = new JSONObject(features, properties);
            }
            ModulePrefs prefs = gadget.getSpec().getModulePrefs();
            JSONObject featureMap = new JSONObject();
            for (Feature feature : prefs.getFeatures().values()) {
                featureMap.put(feature.getName(), feature.getParams());
            }
            config.put("core.util", (Object)featureMap);
            SecurityToken authToken = context.getToken();
            if (authToken != null) {
                String trustedJson;
                JSONObject jSONObject = new JSONObject();
                String updatedToken = authToken.getUpdatedToken();
                if (updatedToken != null) {
                    jSONObject.put("authToken", (Object)updatedToken);
                }
                if ((trustedJson = authToken.getTrustedJson()) != null) {
                    jSONObject.put("trustedJson", (Object)trustedJson);
                }
                config.put("shindig.auth", (Object)jSONObject);
            }
            return "gadgets.config.init(" + config.toString() + ");\n";
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private void injectMessageBundles(Gadget gadget, GadgetContent content) throws GadgetException {
        GadgetContext context = gadget.getContext();
        MessageBundle bundle = this.messageBundleFactory.getBundle(gadget.getSpec(), context.getLocale(), context.getIgnoreCache());
        String msgs = new JSONObject(bundle.getMessages()).toString();
        content.appendHead("gadgets.Prefs.setMessages_(").appendHead(msgs).appendHead(");");
    }

    private void injectPreloads(Gadget gadget, GadgetContent content) {
        JSONObject preload = new JSONObject();
        Preloads preloads = gadget.getPreloads();
        for (String name : preloads.getKeys()) {
            try {
                preload.put(name, preloads.getData(name).toJson());
            }
            catch (PreloadException e) {
                LOG.log(Level.WARNING, "Unexpected error attempting to preload " + name, e);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        content.appendHead("gadgets.io.preloaded_=").appendHead(preload.toString()).appendHead(";");
    }

    private GadgetContent createGadgetContent(Gadget gadget, MutableContent mutableContent) {
        String doc = mutableContent.getContent();
        if (doc.contains("<html>") && doc.contains("</html>")) {
            Matcher matcher = DOCUMENT_SPLIT_PATTERN.matcher(doc);
            if (matcher.matches()) {
                GadgetContent content = new GadgetContent();
                content.appendHead(matcher.group(1)).appendHead("<head>").appendHead(matcher.group(2));
                content.appendBody("</head>").appendBody(this.createBodyTag(gadget, matcher.group(3))).appendBody(matcher.group(4));
                content.appendTail("</body></html>");
                return content;
            }
            return this.makeDefaultContent(gadget, mutableContent);
        }
        return this.makeDefaultContent(gadget, mutableContent);
    }

    private GadgetContent makeDefaultContent(Gadget gadget, MutableContent mutableContent) {
        GadgetContent content = new GadgetContent();
        content.appendHead("<html><head>");
        content.appendHead(DEFAULT_HEAD_CONTENT);
        content.appendBody("</head>");
        content.appendBody(this.createBodyTag(gadget, ""));
        content.appendBody(mutableContent.getContent());
        content.appendTail("</body></html>");
        return content;
    }

    private String createBodyTag(Gadget gadget, String extra) {
        LocaleSpec localeSpec = gadget.getLocale();
        if (localeSpec == null) {
            return "<body" + extra + ">";
        }
        return "<body" + extra + " dir='" + localeSpec.getLanguageDirection() + "'>";
    }

    private String finalizeDocument(Gadget gadget, GadgetContent content) {
        return content.assemble();
    }

    private static class GadgetContent {
        private final StringBuilder head = new StringBuilder();
        private final StringBuilder body = new StringBuilder();
        private final StringBuilder tail = new StringBuilder();

        private GadgetContent() {
        }

        GadgetContent appendHead(CharSequence content) {
            this.head.append(content);
            return this;
        }

        GadgetContent appendBody(CharSequence content) {
            this.body.append(content);
            return this;
        }

        GadgetContent appendTail(CharSequence content) {
            this.tail.append(content);
            return this;
        }

        String assemble() {
            return new StringBuilder(this.head.length() + this.body.length() + this.tail.length()).append((CharSequence)this.head).append((CharSequence)this.body).append((CharSequence)this.tail).toString();
        }

        public String toString() {
            return this.assemble();
        }
    }
}

