/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.CssLexer;
import com.google.caja.lexer.CssTokenType;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shindig.gadgets.rewrite.LinkRewriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssRewriter {
    private static final Pattern urlMatcher = Pattern.compile("(url\\s*\\(\\s*['\"]?)([^\\)'\"]*)(['\"]?\\s*\\))", 2);

    public static String rewrite(String content, URI source, LinkRewriter linkRewriter) {
        StringWriter sw = new StringWriter(content.length() * 110 / 100);
        CssRewriter.rewrite(new StringReader(content), source, linkRewriter, sw);
        return sw.toString();
    }

    public static void rewrite(Reader content, URI source, LinkRewriter rewriter, Writer writer) {
        CharProducer producer = CharProducer.Factory.create((Reader)content, (InputSource)new InputSource(source));
        CssLexer lexer = new CssLexer(producer);
        try {
            while (lexer.hasNext()) {
                Token token = lexer.next();
                if (token.type == CssTokenType.URI) {
                    writer.write(CssRewriter.rewriteLink((Token<CssTokenType>)token, source, rewriter));
                    continue;
                }
                writer.write(token.text);
            }
            writer.flush();
        }
        catch (ParseException pe) {
            pe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static String rewriteLink(Token<CssTokenType> token, URI base, LinkRewriter rewriter) {
        Matcher matcher = urlMatcher.matcher(token.text);
        if (!matcher.find()) {
            return token.text;
        }
        return "url(\"" + rewriter.rewrite(matcher.group(2).trim(), base) + "\")";
    }
}

