/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import java.net.URI;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.parse.GadgetHtmlNode;
import org.apache.shindig.gadgets.rewrite.ContentRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.RewriterResults;
import org.apache.shindig.gadgets.spec.View;

public abstract class HtmlContentRewriter
implements ContentRewriter {
    protected abstract RewriterResults rewrite(GadgetHtmlNode var1, URI var2);

    public static String getMimeType(HttpRequest request, HttpResponse original) {
        String mimeType = request.getRewriteMimeType();
        if (mimeType == null) {
            mimeType = original.getHeader("Content-Type");
        }
        return mimeType != null ? mimeType.toLowerCase() : null;
    }

    public RewriterResults rewrite(HttpRequest request, HttpResponse original, MutableContent content) {
        String mimeType = HtmlContentRewriter.getMimeType(request, original);
        if (mimeType.toLowerCase().contains("html")) {
            return this.rewriteHtml(content.getParseTree(), request.getUri().toJavaUri());
        }
        return null;
    }

    public RewriterResults rewrite(Gadget gadget, MutableContent content) {
        Uri base = gadget.getSpec().getUrl();
        View view = gadget.getCurrentView();
        if (view != null && view.getHref() != null) {
            base = view.getHref();
        }
        return this.rewriteHtml(content.getParseTree(), base.toJavaUri());
    }

    private RewriterResults rewriteHtml(GadgetHtmlNode root, URI baseUri) {
        if (root != null) {
            return this.rewrite(root, baseUri);
        }
        return null;
    }
}

