/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.GadgetHtmlNode;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.ParsedHtmlNode;

public class MutableContent {
    private String content;
    private GadgetHtmlNode parseTree;
    private ContentEditListener editListener;
    private int parseEditId;
    private int contentParseId;
    private final GadgetHtmlParser contentParser;
    public static final String ROOT_NODE_TAG_NAME = "gadget-root";

    public MutableContent(GadgetHtmlParser contentParser) {
        this.contentParser = contentParser;
        this.parseEditId = 0;
        this.contentParseId = 0;
    }

    public String getContent() {
        if (this.parseEditId > this.contentParseId) {
            this.contentParseId = this.parseEditId;
            StringWriter sw = new StringWriter();
            for (GadgetHtmlNode node : this.parseTree.getChildren()) {
                try {
                    node.render(sw);
                }
                catch (IOException e) {}
            }
            this.content = sw.toString();
        }
        return this.content;
    }

    public void setContent(String newContent) {
        if (this.content == null || !this.content.equals(newContent)) {
            this.content = newContent;
            if (this.editListener != null) {
                this.editListener.stringEdited();
            }
        }
    }

    public GadgetHtmlNode getParseTree() {
        if (this.parseTree != null && !this.editListener.stringWasEdited()) {
            return this.parseTree;
        }
        if (this.content == null || this.contentParser == null) {
            return null;
        }
        this.editListener = new ContentEditListener();
        this.parseTree = new GadgetHtmlNode(ROOT_NODE_TAG_NAME, (String[][])null);
        List<ParsedHtmlNode> parsed = null;
        try {
            parsed = this.contentParser.parse(this.content);
        }
        catch (GadgetException e) {
            return null;
        }
        if (parsed == null) {
            return null;
        }
        for (ParsedHtmlNode parsedNode : parsed) {
            this.parseTree.appendChild(new GadgetHtmlNode(parsedNode, this.editListener));
        }
        this.contentParseId = this.parseEditId;
        return this.parseTree;
    }

    private class ContentEditListener
    implements GadgetHtmlNode.EditListener {
        private boolean stringEdited = false;

        private ContentEditListener() {
        }

        public void nodeEdited() {
            ++MutableContent.this.parseEditId;
            if (this.stringEdited) {
                throw new IllegalStateException("Edited parse node after setting String content");
            }
        }

        private void stringEdited() {
            this.stringEdited = true;
        }

        private boolean stringWasEdited() {
            return this.stringEdited;
        }
    }
}

