/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.gadgets.servlet.JsonRpcHandler;
import org.apache.shindig.gadgets.servlet.RpcException;
import org.json.JSONException;
import org.json.JSONObject;

public class RpcServlet
extends InjectedServlet {
    private static final int MAX_REQUEST_SIZE = 131072;
    private static final Logger logger = Logger.getLogger("org.apache.shindig.gadgets");
    private JsonRpcHandler jsonHandler;

    @Inject
    public void setJsonRpcHandler(JsonRpcHandler jsonHandler) {
        this.jsonHandler = jsonHandler;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int length = request.getContentLength();
        if (length <= 0) {
            logger.info("No Content-Length specified.");
            response.setStatus(411);
            return;
        }
        if (length > 131072) {
            logger.info("Request size too large: " + length);
            response.setStatus(413);
            return;
        }
        ServletInputStream is = request.getInputStream();
        byte[] body = IOUtils.toByteArray((InputStream)is);
        if (body.length != length) {
            logger.info("Wrong size. Length: " + length + " real: " + body.length);
            response.setStatus(400);
            return;
        }
        try {
            String encoding = request.getCharacterEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            JSONObject req = new JSONObject(new String(body, encoding));
            JSONObject resp = this.jsonHandler.process(req);
            response.setStatus(200);
            response.setContentType("application/json; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=rpc.txt");
            response.getWriter().write(resp.toString());
        }
        catch (UnsupportedEncodingException e) {
            response.setStatus(400);
            response.getWriter().write("Unsupported input character set");
            logger.log(Level.INFO, e.getMessage(), e);
        }
        catch (JSONException e) {
            response.setStatus(400);
            response.getWriter().write("Malformed JSON request.");
        }
        catch (RpcException e) {
            response.setStatus(500);
            response.getWriter().write(e.getMessage());
            logger.log(Level.INFO, e.getMessage(), e);
        }
    }
}

