/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.net.URI;
import java.util.logging.Logger;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.TtlCache;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.spec.GadgetSpec;

@Singleton
public class BasicGadgetSpecFactory
implements GadgetSpecFactory {
    static final String RAW_GADGETSPEC_XML_PARAM_NAME = "rawxml";
    static final Uri RAW_GADGET_URI = Uri.parse((String)"http://localhost/raw.xml");
    static final Logger logger = Logger.getLogger(BasicGadgetSpecFactory.class.getName());
    private final HttpFetcher fetcher;
    private final TtlCache<Uri, GadgetSpec> ttlCache;

    @Inject
    public BasicGadgetSpecFactory(HttpFetcher fetcher, CacheProvider cacheProvider, @Named(value="shindig.gadget-spec.cache.capacity") int capacity, @Named(value="shindig.gadget-spec.cache.minTTL") long minTtl, @Named(value="shindig.gadget-spec.cache.maxTTL") long maxTtl) {
        this.fetcher = fetcher;
        this.ttlCache = new TtlCache(cacheProvider, capacity, minTtl, maxTtl);
    }

    public GadgetSpec getGadgetSpec(GadgetContext context) throws GadgetException {
        String rawxml = context.getParameter(RAW_GADGETSPEC_XML_PARAM_NAME);
        if (rawxml != null) {
            return new GadgetSpec(RAW_GADGET_URI, rawxml);
        }
        return this.getGadgetSpec(context.getUrl(), context.getIgnoreCache());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GadgetSpec getGadgetSpec(URI gadgetUri, boolean ignoreCache) throws GadgetException {
        Uri uri = Uri.fromJavaUri((URI)gadgetUri);
        if (ignoreCache) {
            return this.fetchObjectAndCache(uri, ignoreCache);
        }
        TtlCache.CachedObject cached = null;
        TtlCache<Uri, GadgetSpec> ttlCache = this.ttlCache;
        synchronized (ttlCache) {
            cached = this.ttlCache.getElementWithExpiration((Object)uri);
        }
        if (cached.obj == null || cached.isExpired) {
            try {
                return this.fetchObjectAndCache(uri, ignoreCache);
            }
            catch (GadgetException e) {
                if (cached.obj == null) {
                    throw e;
                }
                logger.info("GadgetSpec fetch failed for " + uri + " -  using cached.");
            }
        }
        return (GadgetSpec)cached.obj;
    }

    private GadgetSpec fetchObjectAndCache(Uri url, boolean ignoreCache) throws GadgetException {
        HttpRequest request = new HttpRequest(url).setIgnoreCache(ignoreCache);
        HttpResponse response = this.fetcher.fetch(request);
        if (response.getHttpStatusCode() != 200) {
            throw new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, "Unable to retrieve gadget xml. HTTP error " + response.getHttpStatusCode());
        }
        GadgetSpec spec = new GadgetSpec(url, response.getResponseAsString());
        this.ttlCache.addElement((Object)url, (Object)spec, response.getCacheExpiration());
        return spec;
    }
}

