/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.common.util.HashUtil;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetFeature;
import org.apache.shindig.gadgets.GadgetFeatureRegistry;
import org.apache.shindig.gadgets.JsLibrary;
import org.apache.shindig.gadgets.UrlGenerator;
import org.apache.shindig.gadgets.UserPrefs;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.UserPref;
import org.apache.shindig.gadgets.spec.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DefaultUrlGenerator
implements UrlGenerator {
    private static final Pattern ALLOWED_FEATURE_NAME = Pattern.compile("[0-9a-zA-Z\\.\\-]+");
    private final String jsPrefix;
    private final String iframePrefix;
    private final String jsChecksum;

    @Inject
    public DefaultUrlGenerator(@Named(value="shindig.urls.iframe.prefix") String iframePrefix, @Named(value="shindig.urls.js.prefix") String jsPrefix, GadgetFeatureRegistry registry) {
        this.iframePrefix = iframePrefix;
        this.jsPrefix = jsPrefix;
        StringBuilder jsBuf = new StringBuilder();
        for (GadgetFeature feature : registry.getAllFeatures()) {
            for (JsLibrary library : feature.getJsLibraries(null, null)) {
                jsBuf.append(library.getContent());
            }
        }
        this.jsChecksum = HashUtil.checksum((byte[])jsBuf.toString().getBytes());
    }

    @Override
    public String getBundledJsUrl(Collection<String> features, GadgetContext context) {
        return this.jsPrefix.replace("%host%", context.getHost()).replace("%js%", this.getBundledJsParam(features, context));
    }

    @Override
    public String getBundledJsParam(Collection<String> features, GadgetContext context) {
        StringBuilder buf = new StringBuilder();
        boolean first = false;
        for (String feature : features) {
            if (!ALLOWED_FEATURE_NAME.matcher(feature).matches()) continue;
            if (!first) {
                first = true;
            } else {
                buf.append(':');
            }
            buf.append(feature);
        }
        if (!first) {
            buf.append("core");
        }
        buf.append(".js?v=").append(this.jsChecksum).append("&container=").append(context.getContainer()).append("&debug=").append(context.getDebug() ? "1" : "0");
        return buf.toString();
    }

    @Override
    public String getIframeUrl(Gadget gadget) {
        UriBuilder uri;
        GadgetContext context = gadget.getContext();
        GadgetSpec spec = gadget.getSpec();
        String url = context.getUrl().toString();
        View view = gadget.getCurrentView();
        View.ContentType type = view == null ? View.ContentType.HTML : view.getType();
        switch (type) {
            case URL: {
                uri = new UriBuilder(view.getHref());
                break;
            }
            default: {
                uri = new UriBuilder(Uri.parse((String)this.iframePrefix));
            }
        }
        uri.addQueryParameter("container", context.getContainer());
        if (context.getModuleId() != 0) {
            uri.addQueryParameter("mid", Integer.toString(context.getModuleId()));
        }
        if (context.getIgnoreCache()) {
            uri.addQueryParameter("nocache", "1");
        } else {
            uri.addQueryParameter("v", spec.getChecksum());
        }
        uri.addQueryParameter("lang", context.getLocale().getLanguage());
        uri.addQueryParameter("country", context.getLocale().getCountry());
        uri.addQueryParameter("view", context.getView());
        UserPrefs prefs = context.getUserPrefs();
        for (UserPref pref : gadget.getSpec().getUserPrefs()) {
            String name = pref.getName();
            String value = prefs.getPref(name);
            if (value == null) {
                value = pref.getDefaultValue();
            }
            uri.addQueryParameter("up_" + pref.getName(), value);
        }
        if (!type.equals((Object)View.ContentType.URL)) {
            uri.addQueryParameter("url", url);
        }
        return uri.toString();
    }
}

