/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import java.util.HashMap;
import java.util.Map;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;

public class OAuthClientState {
    private static final int CLIENT_STATE_MAX_AGE_SECS = 3600;
    private static final String REQ_TOKEN_KEY = "r";
    private static final String REQ_TOKEN_SECRET_KEY = "rs";
    private static final String ACCESS_TOKEN_KEY = "a";
    private static final String ACCESS_TOKEN_SECRET_KEY = "as";
    private static final String OWNER_KEY = "o";
    private final Map<String, String> state;
    private final BlobCrypter crypter;

    public OAuthClientState(BlobCrypter crypter) {
        this.state = new HashMap<String, String>();
        this.crypter = crypter;
    }

    public OAuthClientState(BlobCrypter crypter, String stateBlob) {
        this.crypter = crypter;
        Map state = null;
        if (stateBlob != null) {
            try {
                state = crypter.unwrap(stateBlob, 3600);
            }
            catch (BlobCrypterException e) {
                // empty catch block
            }
        }
        this.state = state != null ? state : new HashMap<String, String>();
    }

    public boolean isEmpty() {
        return this.state.isEmpty() || this.state.size() == 1 && this.state.containsKey("t");
    }

    public String getEncryptedState() throws BlobCrypterException {
        return this.crypter.wrap(this.state);
    }

    public String getRequestToken() {
        return this.state.get(REQ_TOKEN_KEY);
    }

    public void setRequestToken(String requestToken) {
        this.state.put(REQ_TOKEN_KEY, requestToken);
    }

    public String getRequestTokenSecret() {
        return this.state.get(REQ_TOKEN_SECRET_KEY);
    }

    public void setRequestTokenSecret(String requestTokenSecret) {
        this.state.put(REQ_TOKEN_SECRET_KEY, requestTokenSecret);
    }

    public String getAccessToken() {
        return this.state.get(ACCESS_TOKEN_KEY);
    }

    public void setAccessToken(String accessToken) {
        this.state.put(ACCESS_TOKEN_KEY, accessToken);
    }

    public String getAccessTokenSecret() {
        return this.state.get(ACCESS_TOKEN_SECRET_KEY);
    }

    public void setAccessTokenSecret(String accessTokenSecret) {
        this.state.put(ACCESS_TOKEN_SECRET_KEY, accessTokenSecret);
    }

    public String getOwner() {
        return this.state.get(OWNER_KEY);
    }

    public void setOwner(String owner) {
        this.state.put(OWNER_KEY, owner);
    }
}

