/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.caja;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.HtmlLexer;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.TokenQueue;
import com.google.caja.lexer.TokenStream;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.DomTree;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.inject.Singleton;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.ParsedHtmlAttribute;
import org.apache.shindig.gadgets.parse.ParsedHtmlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class CajaHtmlParser
implements GadgetHtmlParser {
    @Override
    public List<ParsedHtmlNode> parse(String source) throws GadgetException {
        DomParser parser = this.getParser("<html>" + source + "</html>");
        DomTree.Fragment domTree = null;
        try {
            domTree = parser.parseFragment();
        }
        catch (ParseException e) {
            throw new GadgetException(GadgetException.Code.CSS_PARSE_ERROR, (Throwable)e);
        }
        ArrayList<ParsedHtmlNode> nodes = new ArrayList<ParsedHtmlNode>(domTree.children().size());
        for (DomTree child : domTree.children()) {
            nodes.add(new CajaParsedHtmlNode(child));
        }
        return nodes;
    }

    public DomParser getParser(String content) {
        InputSource source = null;
        try {
            source = new InputSource(new URI("http://dummy.com/"));
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        CharProducer producer = CharProducer.Factory.create((Reader)new StringReader(content), (InputSource)source);
        HtmlLexer lexer = new HtmlLexer(producer);
        SimpleMessageQueue mQueue = new SimpleMessageQueue();
        return new DomParser(new TokenQueue((TokenStream)lexer, source), false, (MessageQueue)mQueue);
    }

    private static class CajaParsedHtmlAttribute
    implements ParsedHtmlAttribute {
        private final String name;
        private final String value;

        private CajaParsedHtmlAttribute(DomTree.Attrib attrib) {
            this.name = attrib.getAttribName();
            this.value = attrib.getAttribValue();
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CajaParsedHtmlNode
    implements ParsedHtmlNode {
        private final List<ParsedHtmlAttribute> attributes;
        private final List<ParsedHtmlNode> children;
        private final String name;
        private final String text;

        private CajaParsedHtmlNode(DomTree elem) {
            if (elem instanceof DomTree.Tag) {
                DomTree.Tag tag = (DomTree.Tag)elem;
                this.attributes = new ArrayList<ParsedHtmlAttribute>();
                this.children = new ArrayList<ParsedHtmlNode>();
                this.name = tag.getTagName();
                this.text = null;
                for (DomTree child : elem.children()) {
                    if (child instanceof DomTree.Attrib) {
                        this.attributes.add(new CajaParsedHtmlAttribute((DomTree.Attrib)child));
                        continue;
                    }
                    this.children.add(new CajaParsedHtmlNode(child));
                }
            } else if (elem instanceof DomTree.Text || elem instanceof DomTree.CData) {
                this.attributes = null;
                this.children = null;
                this.name = null;
                this.text = ((DomTree.Text)elem).getValue();
            } else {
                this.attributes = null;
                this.children = null;
                this.name = null;
                this.text = null;
            }
        }

        @Override
        public List<ParsedHtmlAttribute> getAttributes() {
            return this.attributes;
        }

        @Override
        public List<ParsedHtmlNode> getChildren() {
            return this.children;
        }

        @Override
        public String getTagName() {
            return this.name;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }
}

