/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.Utf8UrlCoder;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.parse.GadgetHtmlNode;
import org.apache.shindig.gadgets.rewrite.ContentRewriter;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.RewriterResults;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsTagConcatContentRewriter
implements ContentRewriter {
    private static final int MAX_URL_LENGTH = 1500;
    private final ContentRewriterFeature.Factory rewriterFeatureFactory;
    private final String concatUrlBase;
    private static final String DEFAULT_CONCAT_URL_BASE = "/gadgets/concat?";

    public JsTagConcatContentRewriter(ContentRewriterFeature.Factory rewriterFeatureFactory, String concatUrlBase) {
        this.rewriterFeatureFactory = rewriterFeatureFactory;
        this.concatUrlBase = concatUrlBase != null ? concatUrlBase : DEFAULT_CONCAT_URL_BASE;
    }

    @Override
    public RewriterResults rewrite(HttpRequest request, HttpResponse original, MutableContent content) {
        return null;
    }

    @Override
    public RewriterResults rewrite(Gadget gadget, MutableContent content) {
        ContentRewriterFeature rewriterFeature = this.rewriterFeatureFactory.get(gadget.getSpec());
        if (!rewriterFeature.isRewriteEnabled() || !rewriterFeature.getIncludedTags().contains("script")) {
            return null;
        }
        LinkedList<GadgetHtmlNode> nodesToProcess = new LinkedList<GadgetHtmlNode>();
        nodesToProcess.add(content.getParseTree());
        String concatBase = this.getJsConcatBase(gadget.getSpec(), rewriterFeature);
        while (!nodesToProcess.isEmpty()) {
            GadgetHtmlNode parentNode = (GadgetHtmlNode)nodesToProcess.remove();
            if (parentNode.isText()) continue;
            List<GadgetHtmlNode> childList = parentNode.getChildren();
            nodesToProcess.addAll(childList);
            ArrayList<GadgetHtmlNode> toRemove = new ArrayList<GadgetHtmlNode>();
            ArrayList<URI> scripts = new ArrayList<URI>();
            boolean processScripts = false;
            for (int i = 0; i < childList.size(); ++i) {
                GadgetHtmlNode cur = childList.get(i);
                if (!cur.isText() && cur.getTagName().equalsIgnoreCase("script") && cur.hasAttribute("src")) {
                    URI scriptUri = null;
                    try {
                        Uri base = gadget.getSpec().getUrl();
                        View view = gadget.getCurrentView();
                        if (view != null && view.getHref() != null) {
                            base = view.getHref();
                        }
                        scriptUri = base.resolve(Uri.parse((String)cur.getAttributeValue("src"))).toJavaUri();
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException(e);
                    }
                    scripts.add(scriptUri);
                    toRemove.add(cur);
                } else if (scripts.size() > 0 && cur.isText() && cur.getText().matches("\\s*")) {
                    toRemove.add(cur);
                } else if (scripts.size() > 0) {
                    processScripts = true;
                }
                if (i == childList.size() - 1) {
                    processScripts = true;
                }
                if (!processScripts || scripts.size() <= 0) continue;
                List<URI> concatUris = this.getConcatenatedUris(concatBase, scripts);
                for (URI concatUri : concatUris) {
                    GadgetHtmlNode newScript = new GadgetHtmlNode("script", (String[][])null);
                    newScript.setAttribute("src", concatUri.toString());
                    parentNode.insertBefore(newScript, (GadgetHtmlNode)toRemove.get(0));
                }
                for (GadgetHtmlNode remove : toRemove) {
                    parentNode.removeChild(remove);
                }
                processScripts = false;
                scripts.clear();
                toRemove.clear();
            }
        }
        return RewriterResults.cacheableIndefinitely();
    }

    private List<URI> getConcatenatedUris(String concatBase, List<URI> uris) {
        LinkedList<URI> concatUris = new LinkedList<URI>();
        int paramIndex = 1;
        StringBuilder builder = null;
        int maxUriLen = 1500 + concatBase.length();
        try {
            int uriIx = 0;
            int lastUriIx = uris.size() - 1;
            for (URI uri : uris) {
                if (paramIndex == 1) {
                    builder = new StringBuilder(concatBase);
                } else {
                    builder.append("&");
                }
                builder.append(paramIndex).append("=").append(URLEncoder.encode(uri.toString(), "UTF-8"));
                if (builder.length() > maxUriLen || uriIx == lastUriIx) {
                    concatUris.add(new URI(builder.toString()));
                    builder = null;
                    paramIndex = 0;
                }
                ++paramIndex;
                ++uriIx;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return concatUris;
    }

    String getJsConcatBase(GadgetSpec spec, ContentRewriterFeature rewriterFeature) {
        return this.concatUrlBase + "rewriteMime" + "=text/javascript&" + "gadget=" + Utf8UrlCoder.encode((String)spec.getUrl().toString()) + "&fp=" + rewriterFeature.getFingerprint() + '&';
    }
}

