/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.lexer;

import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.Token;
import java.net.URI;
import org.apache.shindig.gadgets.rewrite.CssRewriter;
import org.apache.shindig.gadgets.rewrite.LinkRewriter;
import org.apache.shindig.gadgets.rewrite.lexer.HtmlRewriter;
import org.apache.shindig.gadgets.rewrite.lexer.HtmlTagTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleTagRewriter
implements HtmlTagTransformer {
    private URI source;
    private LinkRewriter linkRewriter;
    private StringBuffer sb;

    public StyleTagRewriter(URI source, LinkRewriter linkRewriter) {
        this.source = source;
        this.linkRewriter = linkRewriter;
        this.sb = new StringBuffer(500);
    }

    @Override
    public void accept(Token<HtmlTokenType> token, Token<HtmlTokenType> lastToken) {
        if (token.type == HtmlTokenType.UNESCAPED) {
            this.sb.append(CssRewriter.rewrite(token.text, this.source, this.linkRewriter));
        } else {
            this.sb.append(HtmlRewriter.producePreTokenSeparator(token, lastToken));
            this.sb.append(token.text);
            this.sb.append(HtmlRewriter.producePostTokenSeparator(token, lastToken));
        }
    }

    @Override
    public boolean acceptNextTag(Token<HtmlTokenType> tagStart) {
        return false;
    }

    @Override
    public String close() {
        String result = this.sb.toString();
        this.sb.setLength(0);
        return result;
    }
}

