/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import java.util.Locale;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.MessageBundleFactory;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.apache.shindig.gadgets.spec.MessageBundle;

public abstract class AbstractMessageBundleFactory
implements MessageBundleFactory {
    private static final Locale ALL_ALL = new Locale("all", "ALL");

    public MessageBundle getBundle(GadgetSpec spec, Locale locale, boolean ignoreCache) throws GadgetException {
        MessageBundle parent = this.getParentBundle(spec, locale, ignoreCache);
        MessageBundle child = null;
        LocaleSpec localeSpec = spec.getModulePrefs().getLocale(locale);
        if (localeSpec == null) {
            return parent == null ? MessageBundle.EMPTY : parent;
        }
        Uri messages = localeSpec.getMessages();
        child = messages == null || messages.toString().length() == 0 ? localeSpec.getMessageBundle() : this.fetchBundle(localeSpec, ignoreCache);
        return new MessageBundle(parent, child);
    }

    private MessageBundle getParentBundle(GadgetSpec spec, Locale locale, boolean ignoreCache) throws GadgetException {
        if (locale.getLanguage().equalsIgnoreCase("all")) {
            return null;
        }
        if (locale.getCountry().equalsIgnoreCase("ALL")) {
            return this.getBundle(spec, ALL_ALL, ignoreCache);
        }
        return this.getBundle(spec, new Locale(locale.getLanguage(), "ALL"), ignoreCache);
    }

    protected abstract MessageBundle fetchBundle(LocaleSpec var1, boolean var2) throws GadgetException;
}

