/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.logging.Logger;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.TtlCache;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.AbstractMessageBundleFactory;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.apache.shindig.gadgets.spec.MessageBundle;

@Singleton
public class BasicMessageBundleFactory
extends AbstractMessageBundleFactory {
    static final Logger logger = Logger.getLogger(BasicMessageBundleFactory.class.getName());
    private final HttpFetcher fetcher;
    private final TtlCache<Uri, MessageBundle> ttlCache;
    private final long minTtl;
    private final long maxTtl;

    @Inject
    public BasicMessageBundleFactory(HttpFetcher fetcher, CacheProvider cacheProvider, @Named(value="shindig.message-bundle.cache.capacity") int capacity, @Named(value="shindig.message-bundle.cache.minTTL") long minTtl, @Named(value="shindig.message-bundle.cache.maxTTL") long maxTtl) {
        this.fetcher = fetcher;
        this.minTtl = minTtl;
        this.maxTtl = maxTtl;
        this.ttlCache = new TtlCache(cacheProvider, capacity, minTtl, maxTtl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageBundle fetchBundle(LocaleSpec locale, boolean ignoreCache) throws GadgetException {
        if (ignoreCache) {
            return this.fetchAndCacheBundle(locale, ignoreCache);
        }
        TtlCache.CachedObject cached = null;
        TtlCache<Uri, MessageBundle> ttlCache = this.ttlCache;
        synchronized (ttlCache) {
            cached = this.ttlCache.getElementWithExpiration((Object)locale.getMessages());
        }
        if (cached.obj == null || cached.isExpired) {
            try {
                return this.fetchAndCacheBundle(locale, ignoreCache);
            }
            catch (GadgetException e) {
                if (cached.obj == null) {
                    throw e;
                }
                logger.info("Message bundle fetch failed for " + locale + " -  using cached.");
            }
        }
        return (MessageBundle)cached.obj;
    }

    private MessageBundle fetchAndCacheBundle(LocaleSpec locale, boolean ignoreCache) throws GadgetException {
        HttpResponse response;
        Uri url = locale.getMessages();
        HttpRequest request = new HttpRequest(url).setIgnoreCache(ignoreCache);
        if (this.minTtl == this.maxTtl) {
            request.setCacheTtl((int)(this.maxTtl / 1000L));
        }
        if ((response = this.fetcher.fetch(request)).getHttpStatusCode() != 200) {
            throw new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, "Unable to retrieve message bundle xml. HTTP error " + response.getHttpStatusCode());
        }
        MessageBundle bundle = new MessageBundle(locale, response.getResponseAsString());
        this.ttlCache.addElement((Object)url, (Object)bundle, response.getCacheExpiration());
        return bundle;
    }
}

