/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.RemoteContentFetcherFactory;
import org.apache.shindig.gadgets.oauth.OAuthFetcherFactory;

@Singleton
public class ContentFetcherFactory {
    private final RemoteContentFetcherFactory remoteContentFetcherFactory;
    private final OAuthFetcherFactory oauthFetcherFactory;

    @Inject
    public ContentFetcherFactory(RemoteContentFetcherFactory remoteContentFetcherFactory, OAuthFetcherFactory oauthFetcherFactory) {
        this.remoteContentFetcherFactory = remoteContentFetcherFactory;
        this.oauthFetcherFactory = oauthFetcherFactory;
    }

    public HttpResponse fetch(HttpRequest request) throws GadgetException {
        switch (request.getAuthType()) {
            case NONE: {
                return this.remoteContentFetcherFactory.get().fetch(request);
            }
            case SIGNED: 
            case OAUTH: {
                return this.oauthFetcherFactory.getOAuthFetcher(this.remoteContentFetcherFactory.get(), request).fetch(request);
            }
        }
        return HttpResponse.error();
    }
}

