/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.shindig.gadgets.parse.ParsedHtmlAttribute;
import org.apache.shindig.gadgets.parse.ParsedHtmlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GadgetHtmlNode {
    private final NodeType type;
    private GadgetHtmlNode parentNode;
    private String tagName;
    private Map<String, String> attributes;
    private List<GadgetHtmlNode> children;
    private String text;
    private EditListener editListener;

    public GadgetHtmlNode(ParsedHtmlNode parsed, EditListener editListener) {
        if (parsed.getText() == null) {
            this.type = NodeType.TAG;
            this.parentNode = null;
            this.tagName = parsed.getTagName();
            this.attributes = new HashMap<String, String>();
            for (ParsedHtmlAttribute attrib : parsed.getAttributes()) {
                this.setAttribute(attrib.getName(), attrib.getValue());
            }
            this.children = new LinkedList<GadgetHtmlNode>();
            for (ParsedHtmlNode node : parsed.getChildren()) {
                this.appendChild(new GadgetHtmlNode(node, editListener));
            }
        } else {
            this.type = NodeType.TEXT;
            this.setText(parsed.getText());
        }
        this.editListener = editListener;
    }

    public GadgetHtmlNode(String tag, String[][] attribs) {
        this.type = NodeType.TAG;
        this.tagName = tag;
        this.attributes = new HashMap<String, String>();
        if (attribs != null) {
            for (String[] attrib : attribs) {
                if (attrib == null || attrib.length != 2) {
                    throw new UnsupportedOperationException("Coding error: Invalid GadgetHtmlNode creation");
                }
                this.setAttribute(attrib[0], attrib[1]);
            }
        }
        this.children = new LinkedList<GadgetHtmlNode>();
    }

    public GadgetHtmlNode(String text) {
        this.type = NodeType.TEXT;
        this.setText(text);
    }

    public boolean isText() {
        return this.type == NodeType.TEXT;
    }

    public String getTagName() {
        this.validateNodeType(NodeType.TAG);
        return this.tagName;
    }

    public boolean setTagName(String newTag) {
        this.validateNodeType(NodeType.TAG);
        if (this.tagName != null && (newTag = newTag.trim()).matches("[\\w\\-_:]+")) {
            this.tagName = newTag;
            this.sendEditNotice();
            return true;
        }
        return false;
    }

    public String getAttributeValue(String key) {
        this.validateNodeType(NodeType.TAG);
        return this.attributes.get(key);
    }

    public boolean removeAttribute(String key) {
        boolean ret;
        this.validateNodeType(NodeType.TAG);
        boolean hasBefore = this.hasAttribute(key);
        this.attributes.remove(key);
        boolean bl = ret = hasBefore && !this.hasAttribute(key);
        if (ret) {
            this.sendEditNotice();
        }
        return ret;
    }

    public boolean setAttribute(String key, String value) {
        this.validateNodeType(NodeType.TAG);
        String putKey = this.validateAttributeKey(key);
        if (putKey == null) {
            return false;
        }
        this.attributes.put(putKey, value);
        this.sendEditNotice();
        return true;
    }

    public boolean hasAttribute(String key) {
        this.validateNodeType(NodeType.TAG);
        return this.attributes.containsKey(key);
    }

    public Set<String> getAttributeKeys() {
        this.validateNodeType(NodeType.TAG);
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    public void appendChild(GadgetHtmlNode node) {
        this.insertBefore(node, null);
    }

    public void insertBefore(GadgetHtmlNode node, GadgetHtmlNode before) {
        this.validateNodeType(NodeType.TAG);
        node.setParentNode(this);
        if (before == null) {
            this.children.add(node);
        } else {
            int befIx = this.children.indexOf(before);
            if (befIx >= 0) {
                this.children.add(befIx, node);
            } else {
                this.children.add(node);
            }
        }
        this.sendEditNotice();
    }

    public boolean removeChild(GadgetHtmlNode node) {
        this.validateNodeType(NodeType.TAG);
        node.setParentNode(null);
        boolean ret = this.children.remove(node);
        if (ret) {
            this.sendEditNotice();
        }
        return ret;
    }

    public void clearChildren() {
        this.validateNodeType(NodeType.TAG);
        for (GadgetHtmlNode child : this.getChildren()) {
            this.removeChild(child);
        }
    }

    public GadgetHtmlNode getParentNode() {
        return this.parentNode;
    }

    private void setParentNode(GadgetHtmlNode parent) {
        if (this.parentNode != parent) {
            this.sendEditNotice();
        }
        this.parentNode = parent;
    }

    public List<GadgetHtmlNode> getChildren() {
        this.validateNodeType(NodeType.TAG);
        return Collections.unmodifiableList(new ArrayList<GadgetHtmlNode>(this.children));
    }

    public String getText() {
        this.validateNodeType(NodeType.TEXT);
        return this.text;
    }

    public void setText(String text) {
        this.validateNodeType(NodeType.TEXT);
        this.text = text;
        this.sendEditNotice();
    }

    public void render(Writer w) throws IOException {
        if (this.isText()) {
            this.renderText(w);
        } else {
            w.append('<').append(this.tagName);
            for (String attrKey : this.getAttributeKeys()) {
                String attrValue = this.getAttributeValue(attrKey);
                w.append(' ').append(attrKey);
                if (attrValue == null) continue;
                w.append("=\"").append(attrValue.replaceAll("\"", "&#34;")).append('\"');
            }
            if (this.children.size() == 0 && !this.tagName.equalsIgnoreCase("style") && !this.tagName.equalsIgnoreCase("script")) {
                w.append("/>");
            } else {
                w.append('>');
                for (GadgetHtmlNode child : this.children) {
                    child.render(w);
                }
                w.append("</").append(this.tagName).append('>');
            }
        }
    }

    private void renderText(Writer w) throws IOException {
        String parentTag;
        String rawText = this.getText();
        String string = parentTag = this.getParentNode() != null ? this.getParentNode().getTagName() : null;
        if (parentTag != null && (parentTag.equalsIgnoreCase("script") || parentTag.equalsIgnoreCase("style"))) {
            w.append(rawText);
            return;
        }
        int commentStart = 0;
        int curPos = 0;
        while ((commentStart = rawText.indexOf("<!--", curPos)) >= 0) {
            w.append(StringEscapeUtils.escapeHtml((String)rawText.substring(curPos, commentStart)));
            int commentEnd = rawText.indexOf("-->", commentStart);
            if (commentEnd == -1) {
                w.append(rawText.substring(commentStart));
                return;
            }
            int endPos = commentEnd + "-->".length();
            w.append(rawText.substring(commentStart, endPos));
            curPos = endPos;
        }
        w.append(StringEscapeUtils.escapeHtml((String)rawText.substring(curPos)));
    }

    private String validateAttributeKey(String key) {
        if (key == null) {
            return null;
        }
        if (!(key = key.trim()).matches("[\\w\\d_\\-:]+")) {
            return null;
        }
        return key;
    }

    private void validateNodeType(NodeType expected) {
        if (this.type != expected) {
            throw new UnsupportedOperationException("Code error: Attempted " + (Object)((Object)expected) + " operation on node of type " + (Object)((Object)this.type));
        }
    }

    private void sendEditNotice() {
        if (this.editListener != null) {
            this.editListener.nodeEdited();
        }
    }

    public static interface EditListener {
        public void nodeEdited();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NodeType {
        TAG,
        TEXT;

    }
}

