/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.caja;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.HtmlLexer;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.TokenQueue;
import com.google.caja.lexer.TokenStream;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.DomTree;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.ParsedHtmlAttribute;
import org.apache.shindig.gadgets.parse.ParsedHtmlNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class CajaHtmlParser
extends GadgetHtmlParser {
    Provider<HTMLDocument> documentProvider;

    @Inject
    public CajaHtmlParser(Provider<HTMLDocument> documentProvider) {
        this.documentProvider = documentProvider;
    }

    @Override
    public List<ParsedHtmlNode> parse(String source) throws GadgetException {
        DomTree.Fragment domTree = this.getFragment(source);
        ArrayList<ParsedHtmlNode> nodes = new ArrayList<ParsedHtmlNode>(domTree.children().size());
        for (DomTree child : domTree.children()) {
            nodes.add(new CajaParsedHtmlNode(child));
        }
        return nodes;
    }

    @Override
    public Document parseDom(String source) throws GadgetException {
        return this.makeDocument(this.getFragment(source));
    }

    DomTree.Fragment getFragment(String content) throws GadgetException {
        DomParser parser = this.getParser(content);
        try {
            return parser.parseFragment();
        }
        catch (ParseException pe) {
            try {
                DomTree.Fragment fragment = this.getParser("<HTML>" + content + "</HTML>").parseFragment();
                return new DomTree.Fragment(((DomTree)fragment.children().get(0)).children());
            }
            catch (ParseException pe2) {
                throw new GadgetException(GadgetException.Code.HTML_PARSE_ERROR, (Throwable)pe2);
            }
        }
    }

    DomParser getParser(String content) {
        InputSource source = null;
        try {
            source = new InputSource(new URI("http://dummy.com/"));
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        CharProducer producer = CharProducer.Factory.create((Reader)new StringReader(content), (InputSource)source);
        HtmlLexer lexer = new HtmlLexer(producer);
        SimpleMessageQueue mQueue = new SimpleMessageQueue();
        return new DomParser(new TokenQueue((TokenStream)lexer, source), false, (MessageQueue)mQueue);
    }

    private HTMLDocument makeDocument(DomTree.Fragment fragment) {
        HTMLDocument htmlDocument = (HTMLDocument)this.documentProvider.get();
        for (DomTree node : fragment.children()) {
            if (!(node instanceof DomTree.Tag) || !((DomTree.Tag)node).getTagName().equalsIgnoreCase("HTML")) continue;
            CajaHtmlParser.recurseDocument(htmlDocument, htmlDocument, node);
            return htmlDocument;
        }
        Node root = htmlDocument.appendChild(htmlDocument.createElement("HTML"));
        for (DomTree child : fragment.children()) {
            CajaHtmlParser.recurseDocument(htmlDocument, root, child);
        }
        return htmlDocument;
    }

    private static void recurseDocument(HTMLDocument doc, Node parent, DomTree elem) {
        if (elem instanceof DomTree.Tag) {
            DomTree.Tag tag = (DomTree.Tag)elem;
            Element element = doc.createElement(tag.getTagName());
            parent.appendChild(element);
            for (DomTree child : elem.children()) {
                CajaHtmlParser.recurseDocument(doc, element, child);
            }
        } else if (elem instanceof DomTree.Attrib) {
            DomTree.Attrib attrib = (DomTree.Attrib)elem;
            Attr domAttrib = doc.createAttribute(attrib.getAttribName());
            parent.getAttributes().setNamedItem(domAttrib);
            domAttrib.setValue(attrib.getAttribValue());
        } else if (elem instanceof DomTree.Text) {
            parent.appendChild(doc.createTextNode(elem.getValue()));
        } else if (elem instanceof DomTree.CData) {
            parent.appendChild(doc.createCDATASection(elem.getValue()));
        }
    }

    private static class CajaParsedHtmlAttribute
    implements ParsedHtmlAttribute {
        private final String name;
        private final String value;

        private CajaParsedHtmlAttribute(DomTree.Attrib attrib) {
            this.name = attrib.getAttribName();
            this.value = attrib.getAttribValue();
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CajaParsedHtmlNode
    implements ParsedHtmlNode {
        private final List<ParsedHtmlAttribute> attributes;
        private final List<ParsedHtmlNode> children;
        private final String name;
        private final String text;

        private CajaParsedHtmlNode(DomTree elem) {
            if (elem instanceof DomTree.Tag) {
                DomTree.Tag tag = (DomTree.Tag)elem;
                this.attributes = new ArrayList<ParsedHtmlAttribute>(1);
                this.children = new ArrayList<ParsedHtmlNode>();
                this.name = tag.getTagName();
                this.text = null;
                for (DomTree child : elem.children()) {
                    if (child instanceof DomTree.Attrib) {
                        this.attributes.add(new CajaParsedHtmlAttribute((DomTree.Attrib)child));
                        continue;
                    }
                    this.children.add(new CajaParsedHtmlNode(child));
                }
            } else if (elem instanceof DomTree.Text || elem instanceof DomTree.CData) {
                this.attributes = null;
                this.children = null;
                this.name = null;
                this.text = ((DomTree.Text)elem).getValue();
            } else {
                this.attributes = null;
                this.children = null;
                this.name = null;
                this.text = null;
            }
        }

        @Override
        public List<ParsedHtmlAttribute> getAttributes() {
            return this.attributes;
        }

        @Override
        public List<ParsedHtmlNode> getChildren() {
            return this.children;
        }

        @Override
        public String getTagName() {
            return this.name;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }
}

